// test con STM32F401 + IDB05A1.
// App utilizzata per i test TxEddystone-URL

#include <events/mbed_events.h>
#include "mbed.h"
#include "ble/BLE.h"
#include "ble/DiscoveredCharacteristic.h"
#include "ble/DiscoveredService.h"

#define MAXNUMCHAR 255 // massima dimensione del comando inviato nell'URI

static const int URI_MAX_LENGTH = 18;             // Maximum size of service data in ADV packets

static EventQueue eventQueue(/* event count */ 16 * EVENTS_EVENT_SIZE);

// genera un oggetto serial collegato al PC
Serial pc(USBTX, USBRX);

// comando ricevuto da iBeacon = caratteri tra prefisso e suffisso dell'indirizzo URI
char caComando[MAXNUMCHAR];
// ultimo comando ricevuto da iBeacon
char caOldComando[MAXNUMCHAR];    

DigitalOut led1(LED1, 1); // LED su scheda
  
void periodicCallback(void)
{
    led1 = !led1; /* Do blinky on LED1 while we're waiting for BLE events */
}

//****************************************
// Decodifica URI ricevuto da Eddystone
//****************************************
void decodeURI(const uint8_t* uriData, const size_t uriLen)
{
   
    const char *prefixes[] = 
    {
        "http://www.",
        "https://www.",
        "http://",
        "https://",
        "urn:uuid:"
    };
        
    const size_t NUM_PREFIXES = sizeof(prefixes) / sizeof(char *);
    
    const char *suffixes[] = 
    {
        ".com/",
        ".org/",
        ".edu/",
        ".net/",
        ".info/",
        ".biz/",
        ".gov/",
        ".com",
        ".org",
        ".edu",
        ".net",
        ".info",
        ".biz",
        ".gov"
    };
    const size_t NUM_SUFFIXES = sizeof(suffixes) / sizeof(char *);
    size_t index = 0;
    
    
    /*------------- Diagnostica -------------------
    pc.printf("sizeofprefixes: %d\r\n", sizeof(prefixes));
    pc.printf("sizeofchar: %d\r\n", sizeof(char *));
    pc.printf("NUM_PREFIXES: %d\r\n", NUM_PREFIXES);
    
    pc.printf("sizeofsuffixes: %d\r\n", sizeof(suffixes));
    pc.printf("sizeofchar: %d\r\n", sizeof(char *));
    pc.printf("NUM_SUFFIXES: %d\r\n", NUM_SUFFIXES);
    ------------- Diagnostica -------------------*/

    //pc.printf("uriLen: %d\r\n", uriLen); // diagnostica
    //pc.printf("uriData: %s\r\n", uriData); // diagnostica

    //------------- Diagnostica -------------------
    // il primo carattere contiene l'indice dell'array dei prefissi: p.e. indice 2 significa prefixes[2] = "http://"
    if (uriData[index] < NUM_PREFIXES) 
    {
        // stampa prefisso//
        //pc.printf("%s", prefixes[uriData[index]]); // diagnostica
        index++;
    } 
    else 
    {
        // il prefisso non è tra quelli codificati 
        pc.printf("URL Scheme was not encoded!");
        return;
    }
    pc.printf("\n\r");     
    // Inizializza array comando
    for(index = 0; index < MAXNUMCHAR; index++) 
    {
        caComando[index] = 0;
    }
    index=1;
    // estrai il comando tra indice = 1 e indice = uriLen-1
    while(index < (uriLen-1)) 
    {
        // stampa il dato tra prefisso e suffisso
        //pc.printf("%c", uriData[index]); // Diagnostica
        caComando[index-1]= uriData[index];
        index++;
    }
    pc.printf("\n\r");
    
    // stampa suffisso che si trova all'indice(uriLen-1)
    //pc.printf("%s\n\r", suffixes[uriData[uriLen-1]]); // Diagnostica
    //------------- Diagnostica -------------------
}

//**************************************************************
// This function is called every time we scan an advertisement
//**************************************************************
void advertisementCallback(const Gap::AdvertisementCallbackParams_t *params)
{
    struct AdvertisingData_t 
    {
        uint8_t                        length; /* doesn't include itself */
        GapAdvertisingData::DataType_t dataType;
        uint8_t                        data[1];
    } AdvDataPacket;

    struct ApplicationData_t 
    {
        uint8_t applicationSpecificId[2];
        uint8_t frameType;
        uint8_t advPowerLevels;
        uint8_t uriData[URI_MAX_LENGTH];
    } AppDataPacket;

    const uint8_t BEACON_UUID[sizeof(UUID::ShortUUIDBytes_t)] = {0xAA, 0xFE};
    const uint8_t FRAME_TYPE_URL = 0x10;
    const uint8_t APPLICATION_DATA_OFFSET = sizeof(ApplicationData_t) + sizeof(AdvDataPacket.dataType) - sizeof(AppDataPacket.uriData);
    int nIndex;
    AdvertisingData_t *pAdvData;
    size_t index = 0;
    
    // parsing dell'Advertising ricevuto
    while(index < params->advertisingDataLen) 
    {
        pAdvData = (AdvertisingData_t *)&params->advertisingData[index];
        //+++pc.printf("pAdv DataType= %x\r\n",pAdvData->dataType); // Diagnostica

        if (pAdvData->dataType == GapAdvertisingData::SERVICE_DATA) 
        {
            ApplicationData_t *pAppData = (ApplicationData_t *) pAdvData->data;
            
            //+++pc.printf("pAppData ApplicationSpecificID= %x\r\n",pAppData->applicationSpecificId); // Diagnostica
            //+++pc.printf("pAppData frameType= %x\r\n",pAppData->frameType); // Diagnostica
            //pc.printf("------------------------------> Sono arrivato qui\r\n"); // Diagnostica
            if (!memcmp(pAppData->applicationSpecificId, BEACON_UUID, sizeof(BEACON_UUID))
                                             && 
                            (pAppData->frameType == FRAME_TYPE_URL)) 
            {
                decodeURI(pAppData->uriData, pAdvData->length - APPLICATION_DATA_OFFSET);
                
                pc.printf("-------------------------------------------------> Sono partito da qui\r\n");
                // genera messaggio vocale se il comando ricevuto è diverso da quello ricevuto precedentemente
                //pc.printf("caComando: %s\r\n", caComando); //Diagnostica
                //pc.printf("caOldComando: %s\r\n", caOldComando); //Diagnostica
                if(strcmp(caComando,caOldComando) != 0)
                {
                    if(strcmp(caComando,"prova") == 0)
                    {
                        pc.printf("Ricevuto Comando PROVA\r\n");
                    }
                    
                    if(strcmp(caComando,"welcome") == 0)
                    {
                        pc.printf("Ricevuto Comando WELCOME\r\n"); // diagnostica
                    }
                
                    if(strcmp(caComando,"uscita") == 0)
                    {
                        pc.printf("Ricevuto Comando USCITA\r\n"); // diagnostica
                    }
                    
                    if(strcmp(caComando,"ingresso") == 0)
                    {
                        pc.printf("Ricevuto Comando INGRESSO\r\n");
                    }
                    
                    if(strcmp(caComando,"cambioora") == 0)
                    {
                        pc.printf("Ricevuto Comando CAMBIO ORA\r\n");
                    }
                    
                    
                    // copia caComando in caOldComando
                    for (nIndex = 0; nIndex < MAXNUMCHAR; nIndex++)
                    {
                        if(nIndex < strlen(caComando))
                        {
                            caOldComando[nIndex] = caComando[nIndex];
                        }
                        else
                        {
                            // filling della stringa di comando
                            caOldComando[nIndex] = 0;
                        }
                    }
                }    
            }
        }
        index += (pAdvData->length + 1);
    }
}
//***************************************
// CallBack avviata su BLEInitError
//***************************************
void onBleInitError(BLE &ble, ble_error_t error)
{
   /* Initialization error handling should go here */
}

//***************************************
// Callback avviata su BLEInitComplete
//***************************************
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) 
    {
        onBleInitError(ble, error);
        return;
    }

    if (ble.getInstanceID() != BLE::DEFAULT_INSTANCE) 
    {
        return;
    }

    ble.gap().setScanParams(1800 /* scan interval */, 1500 /* scan window */);
    ble.gap().startScan(advertisementCallback);
}
//**************************************************
// Callback avviata su scheduleBleEventsPtocessing
//**************************************************
void scheduleBleEventsProcessing(BLE::OnEventsToProcessCallbackContext* context) 
{
    BLE &ble = BLE::Instance();
    eventQueue.call(Callback<void()>(&ble, &BLE::processEvents));
}

/************/
/*   MAIN   */
/************/
int main()
{
    // configura velocità della comunicazione seriale su USB-VirtualCom e invia messaggio di benvenuto
    pc.baud(921600); //921600 bps// configura velocità della comunicazione seriale su USB-VirtualCom e invia messaggio di benvenuto
    pc.printf("Hallo\r\n");

    // inizializza variabili
    for(int i=0; i < MAXNUMCHAR; i++)
    {
        caComando[i]=0;
        caOldComando[i]=0;
    }

    eventQueue.call_every(100, periodicCallback);

    BLE &ble = BLE::Instance();
    ble.onEventsToProcess(scheduleBleEventsProcessing);
    ble.init(bleInitComplete);

    eventQueue.dispatch_forever();

    return 0;

}