// Test motore CC, pilotato in PWM
// test interruttore simulato con un output OpenDrain
// testato su F070RB, F401

#include "mbed.h"
#include<stdlib.h>

// Definizione periferica USB seriale del PC
Serial pc(USBTX, USBRX, 921600); // seriale di comunicazione con il PC. Associati a PA_11 e PA_12

// Definizione periferica seriale del Modulo BLE ELETT114A
Serial myBLE(PA_9, PA_10, 9600); //Tx, Rx, bps


// User Button, LED  
DigitalIn myButton(USER_BUTTON); // pulsante Blu sulla scheda. Associato a PC_13
DigitalOut myLed(LED2); // LED verde sulla scheda. Associato a PA_5

// Output per pilotaggio di un motore PWM
PwmOut OutPWM (PB_8);

// Output Open Drain No Pull
DigitalInOut SwitchRouter (PB_9, PIN_OUTPUT, OpenDrain, 0);
  
// digital Out di Prova
DigitalOut Prova (PA_6);

/**********/
/*  MAIN  */
/**********/
int main()
{
   
    // messaggio di benvenuto
    pc.printf("\r\n************  Hallo ************** \r\n");
    pc.printf("*********** Test PWM *************\r\n");

    // out di prova
    Prova = 1;
    // inizializza OpenDrain
    SwitchRouter.mode(PullNone);
       
    // inizializza il PWM
    OutPWM.period_ms(50); // periodo del PWM
    OutPWM.write(0.0); // inizializza duty cycle del PWM
    
    // Ciclo principale
    while(true)
    {
        // accende il motore se è premuto lo User Button
        if(myButton == 0)
        {
            // accendi LED su scheda
            myLed = 1;
            // regola velocità del motore modificando duty cycle del PWM
            OutPWM.write(0.4);  // velocità massima = 1.0
            
            // accendi/spegni il router
            SwitchRouter = 1;
        }
        else
        {
            // spegni LED su scheda
            myLed = 0;
            // ferma il PWM
            OutPWM.write(0.0); // motore fermo = 0.0
            // disattiva l'OpenDrainper il Router
            SwitchRouter = 0;
        } // if(myButton==0)
    } // while(true) Principale
}