#include "mbed.h"
#include "HIDScope.h"
#include "QEI.h"
// test if colaboration is working
// myled is an object of class PwmOut. It uses the LED_RED pin
// in human speech: myled is an output that can be controlled with PWM. LED_RED is the pin which is connected to the output
PwmOut myled2(D5);
PwmOut myled1(D6);

DigitalOut motor1direction(D7);
// pot is an object of class AnalogIn. It uses the PTB0 pin
// in human speech: pot is an analog input. You can read the voltage on pin PTB0
AnalogIn pot1(A0);
AnalogIn pot2(A1);

//HIDScope scope(1);
Serial pc(USBTX, USBRX);
QEI wheel (D12, D13, NC, 624);
float lastpotread = 0;
int countsPerRound = 32*131;
float gototick;
int currentpulses;
int errorsignal;
float Kf=0.2;
//start 'main' function. Should be done once in every C(++) program
int main()
{
    //setup some stuff
    //period of PWM signal is 10kHz. Every 100 microsecond a new PWM period is started
    myled1.period_ms(0.1);
    myled2.period_ms(0.1);
    myled1=0.5;
    //motor1=1;
    //while 1 is unequal to zero. For humans: loop forever
    while(1) {
        currentpulses=wheel.getPulses();
        gototick = pot1.read()*countsPerRound;
        errorsignal=gototick-currentpulses;
        if (lastpotread != pot1.read()){
            lastpotread=pot1.read();
            pc.printf("potvalue: %f, position: %d, control speed: %f \n\r",gototick,currentpulses,errorsignal*Kf);
        }
        
        if (errorsignal > 0)
        {
            motor1direction=0; 
            myled1=errorsignal*Kf;
            
        }
        else
        {
            motor1direction=1;
            myled1=-errorsignal*Kf;
        }
        
        
        //myled1.write(pot1.read());
        //myled2.write(pot2.read());
        //wait some time to give the LED output a few PWM cycles. Otherwise a new value is written before the previously set PWM period (of 100microseconds) is finished
        //This loop executes at roughly 100Hz (1/0.01s)
        wait(0.01);
    }
}

