#include "mbed.h"
#include "HIDScope.h"


// myled is an object of class PwmOut. It uses the LED_RED pin
// in human speech: myled is an output that can be controlled with PWM. LED_RED is the pin which is connected to the output
PwmOut myled2(D5);
PwmOut myled1(D6);

//DigitalOut motor1(D4);
// pot is an object of class AnalogIn. It uses the PTB0 pin
// in human speech: pot is an analog input. You can read the voltage on pin PTB0
AnalogIn pot1(A0);
AnalogIn pot2(A1);

//HIDScope scope(1);
Serial pc(USBTX, USBRX);

//start 'main' function. Should be done once in every C(++) program
int main()
{
    //setup some stuff
    //period of PWM signal is 10kHz. Every 100 microsecond a new PWM period is started
    myled1.period_ms(0.1);
    myled2.period_ms(0.1);
    //motor1=1;
    //while 1 is unequal to zero. For humans: loop forever
    while(1) {
        pc.printf("potvalue: %f \n",pot1.read());
        
        myled1.write(pot1.read());
        myled2.write(pot2.read());
        //wait some time to give the LED output a few PWM cycles. Otherwise a new value is written before the previously set PWM period (of 100microseconds) is finished
        //This loop executes at roughly 100Hz (1/0.01s)
        wait(0.01);
    }
}

