/*  TODO:   integrate with control
*/
 
#include "mbed.h"
#include "HIDScope.h"
#include "biquadFilter.h"
#include <cmath>
 
HIDScope    scope(2); // HIDScope declared
 
int Fs = 512; // sampling frequency
const double low_b1 = 1.480219865318266e-04; //filter coefficients - second order butterworth filters at 2 hz low and 25 hz high, coefficents based on Fs of 512.
const double low_b2 = 2.960439730636533e-04;
const double low_b3 = 1.480219865318266e-04;
const double low_a2 = -1.965293372622690e+00; // a1 is normalized to 1
const double low_a3 = 9.658854605688177e-01;
const double high_b1 = 8.047897937631126e-01;
const double high_b2 = -1.609579587526225e+00;
const double high_b3 = 8.047897937631126e-01;
const double high_a2 = -1.571102440190402e+00; // a1 is normalized to 1
const double high_a3 = 6.480567348620491e-01;
biquadFilter highpass1(high_a2, high_a3, high_b1, high_b2, high_b3); // different objects for different inputs, otherwise the v1 and v2 variables get fucked up
biquadFilter highpass2(high_a2, high_a3, high_b1, high_b2, high_b3);
biquadFilter highpass3(high_a2, high_a3, high_b1, high_b2, high_b3);
biquadFilter highpass4(high_a2, high_a3, high_b1, high_b2, high_b3);
biquadFilter lowpass1(low_a2, low_a3, low_b1, low_b2, low_b3);
biquadFilter lowpass2(low_a2, low_a3, low_b1, low_b2, low_b3);
biquadFilter lowpass3(low_a2, low_a3, low_b1, low_b2, low_b3);
biquadFilter lowpass4(low_a2, low_a3, low_b1, low_b2, low_b3);
 
AnalogIn input1(A0); // declaring the 4 inputs
AnalogIn input2(A1);
AnalogIn input3(A2);
AnalogIn input4(A3);
double u1; double y1; // declaring the input variables
double u2; double y2;
double u3; double y3;
double u4; double y4;

Ticker T1;
volatile bool sample_go;

InterruptIn cali_button(PTA4); // initialize interrupt button for calibration stuff
double cali_fact = 8; // calibration factor to normalize filter output to a scale of 0 - 1
double cali_array[2560] = {}; // array to store values in


void sample_filter()
{
    u1 = input1; u2 = input2; u3 = input3; u4 = input4; // sample
    y1 = highpass1.step(u1); y2 = highpass2.step(u2); y3 = highpass3.step(u3); y4 = highpass4.step(u4); // filter order is: high-pass --> rectify --> low-pass
    y1 = fabs(y1); y2 = fabs(y2); y3 = fabs(y3); y4 = fabs(y4);
    y1 = lowpass1.step(y1)*cali_fact; y2 = lowpass2.step(y2)*cali_fact; y3 = lowpass3.step(y3)*cali_fact; y4 = lowpass4.step(y4)*cali_fact; // roughly normalize to a scale of 0 - 1, where 0 is minimum and 1 is roughly the maximum output of dennis.
}
 
void samplego() // ticker function, set flag to true every sample interval
{
    sample_go = 1;
}

void calibrate() // function to calibrate the emg signals from the user. It takes 5 seconds of measurements of maximum output, then takes the max and normalizes to that.
{
    double cali_max = 0; // declare max
    for(int cali_index = 0; cali_index < 2560; cali_index++)
    {
        sample_filter();
        cali_array[cali_index] = y1;
        wait((float)1/Fs);
    }
     for(int cali_index2 = 0; cali_index2<2560; cali_index2++)
     {
          if(cali_array[cali_index2] > cali_max)
                cali_max = cali_array[cali_index2];
     }
     cali_fact = (double)1/cali_max;
}
 
int main()
{
    T1.attach(&samplego, (float)1/Fs);
    cali_button.rise(&calibrate);
    while(1)
    {
        if(sample_go)
        {
            sample_filter();
            scope.set(0,y1);
            scope.set(1,y2);
            scope.send();
            sample_go = 0;
        } 
    } // while end   
} // main end