#include "mbed.h"
#include "HIDScope.h"
#include <cstring>
#include <cmath>
#include "biquadFilter.h"

AnalogIn input1(A0); // first EMG input
AnalogIn input2(A1); // second EMG input
AnalogIn input3(A2); // third EMG input
AnalogIn input4(A3); // fourth EMG input

HIDScope    scope(2); // HIDScope declared

// note that this filter is specified for a Fs of 512;
// Butterworth low pass filter, second order at 2 hertz
// Butterworth high pass filter, second order at 25 hertz
int Fs = 512;
const double low_b1 = 1.480219865318266e-04; //filter coefficients
const double low_b2 = 2.960439730636533e-04;
const double low_b3 = 1.480219865318266e-04;
const double low_a2 = -1.965293372622690e+00; // a1 is normalized to 1
const double low_a3 = 9.658854605688177e-01;
const double high_b1 = 8.047897937631126e-01;
const double high_b2 = -1.609579587526225e+00;
const double high_b3 = 8.047897937631126e-01;
const double high_a2 = -1.571102440190402e+00; // a1 is normalized to 1
const double high_a3 = 6.480567348620491e-01;

double inputs_current [4] = {}; // declaring an array for the inputs
double inputs_previous [4] = {}; // previous input
double inputs_previous2 [4] = {}; // second previous input

double outputs_current [4] = {}; // same for outputs
double outputs_previous [4] = {};
double outputs_previous2 [4] = {};

Ticker T1;

// this function will be called by a ticker sample and filter
volatile bool sample_go;

void samplego()
{
    sample_go = 1;
}


void sample() // arrays are passed by reference, I think? 
{
    memmove(inputs_previous2, inputs_previous, sizeof(inputs_previous2)); // I hope this black magic works, equaling the array of previous2 to previous
    memmove(inputs_previous, inputs_current, sizeof(inputs_previous)); // black magic again, this time previous to current
    inputs_current[0] = input1;
    inputs_current[1] = input2;
    inputs_current[2] = input3;
    inputs_current[3] = input4;
}

void filter() // filter: high --> full rect --> low 
{
    memmove(outputs_previous2, outputs_previous, sizeof(outputs_previous2)); // moving output one array back
    memmove(outputs_previous, outputs_current, sizeof(outputs_previous)); // same for this output
    for(int n = 0; n <= 3; n++)
    {
        outputs_current[n] = high_b1*inputs_current[n] + high_b2*inputs_previous[n] + high_b3*inputs_previous2[n] - high_a2*outputs_previous[n] - high_a3*outputs_previous2[n];
        outputs_current[n] = fabs(outputs_current[n]);
        outputs_current[n] = (low_b1*inputs_current[n] + low_b2*inputs_previous[n] + low_b3*inputs_previous2[n] - low_a2*outputs_previous[n] - low_a3*outputs_previous2[n]);
        outputs_current[n] = outputs_current[n];
    }
}

int main()
{
    T1.attach(&samplego, (float)1/Fs);
    while("pigs" != "fly")
    {
        if(sample_go)
        {
            sample();
            filter();
            scope.set(0,inputs_current[0]);
            scope.set(1,outputs_current[0]);
            scope.send();
            sample_go = 0;
            
        } 
    } 
} // main end