#include "biquadFilter.h"
#include <cmath>
 
 
const int Fs = 200; // sampling frequency
const double low_b1 = 0.000944691843840; //filter coefficients - second order butterworth filters at 2 hz low and 25 hz high, coefficents based on Fs of 512.
const double low_b2 = 0.001889383687680;
const double low_b3 = 0.000944691843840;
const double low_a2 = -1.911197067426073; // a1 is normalized to 1
const double low_a3 = 0.914975834801434;
const double high_b1 = 0.569035593728849;
const double high_b2 = -1.138071187457699;
const double high_b3 = 0.569035593728849;
const double high_a2 = -0.942809041582063; // a1 is normalized to 1
const double high_a3 = 0.333333333333333;
biquadFilter highpass1(high_a2, high_a3, high_b1, high_b2, high_b3); // different objects for different inputs, otherwise the v1 and v2 variables get fucked up
biquadFilter highpass2(high_a2, high_a3, high_b1, high_b2, high_b3);
biquadFilter highpass3(high_a2, high_a3, high_b1, high_b2, high_b3);
biquadFilter highpass4(high_a2, high_a3, high_b1, high_b2, high_b3);
biquadFilter lowpass1(low_a2, low_a3, low_b1, low_b2, low_b3);
biquadFilter lowpass2(low_a2, low_a3, low_b1, low_b2, low_b3);
biquadFilter lowpass3(low_a2, low_a3, low_b1, low_b2, low_b3);
biquadFilter lowpass4(low_a2, low_a3, low_b1, low_b2, low_b3);
 
AnalogIn input1(A0); // declaring the 4 inputs
AnalogIn input2(A1);
AnalogIn input3(A2);
AnalogIn input4(A3);
double u1; double y1; // declaring the input variables
double u2; double y2;
double u3; double y3;
double u4; double y4;

Ticker T1;
volatile bool sample_go;
volatile bool calibrate_go;

InterruptIn cali_button(PTA4); // initialize interrupt button for calibration stuff
double cali_fact1 = 8;
double cali_fact2 = 8; // calibration factor to normalize filter output to a scale of 0 - 1
double cali_fact3 = 8;
double cali_fact4 = 8;

void sample_filter()
{
    u1 = input1; u2 = input2; u3 = input3; u4 = input4; // sample
    y1 = highpass1.step(u1); y2 = highpass2.step(u2); y3 = highpass3.step(u3); y4 = highpass4.step(u4); // filter order is: high-pass --> rectify --> low-pass
    y1 = fabs(y1); y2 = fabs(y2); y3 = fabs(y3); y4 = fabs(y4);
    y1 = lowpass1.step(y1)*cali_fact1; y2 = lowpass2.step(y2)*cali_fact2; y3 = lowpass3.step(y3)*cali_fact3; y4 = lowpass4.step(y4)*cali_fact4; // roughly normalize to a scale of 0 - 1, where 0 is minimum and 1 is roughly the maximum output of dennis.
}


void calibratego()
{
    calibrate_go = 1;
}

void samplego() // ticker function, set flag to true every sample interval
{
    sample_go = 1;
}

void calibrate() // function to calibrate the emg signals from the user. It takes 5 seconds of measurements of maximum output, then takes the max and normalizes to that.
{
    statusled=0;
    cali_fact1 = 1; cali_fact2 = 1; cali_fact3 = 1; cali_fact4 = 1; 
    double cali_max1 = 0; double cali_max2 = 0; double cali_max3 = 0; double cali_max4 = 0;
    lcd.cls(); 
    lcd.printf("calibrating...\nFlex muscle Y1");
    for(int i = 0; i < 5*Fs; i++)
    {
        sample_filter();
        if(y1 > cali_max1)
        {
            cali_max1 = y1;
        }
        wait(1/(float)Fs);
   }
   statusled=1;
   wait(1); // seperated calibration of muscles, including a wait period of a second between the calibration of each thing.
   statusled=0;
   lcd.cls(); 
   lcd.printf("calibrating...\nFlex muscle Y2");
   for(int i = 0; i < 5*Fs; i++)
    {
        sample_filter();
        if(y2 > cali_max2)
        {
            cali_max2 = y2;
        }
        wait(1/(float)Fs);
   }
   statusled=1;
   wait(1);
   statusled=0;
   lcd.cls(); 
   lcd.printf("calibrating...\nFlex muscle Y3");
    for(int i = 0; i < 5*Fs; i++)
    {
        sample_filter();
        if(y3 > cali_max3)
        {
            cali_max3 = y3;
        }
        wait(1/(float)Fs);
    }
    statusled=1;
    wait(1);
    statusled=0;
    lcd.cls(); 
    lcd.printf("calibrating...\nFlex muscle Y4");
    for(int i = 0; i < 5*Fs; i++)
    {
        sample_filter();
        if(y4 > cali_max4)
        {
            cali_max4 = y4;
        }
        wait(1/(float)Fs);
    }
   cali_fact1 = 1.0/cali_max1;
   cali_fact2 = 1.0/cali_max2;
   cali_fact3 = 1.0/cali_max3;
   cali_fact4 = 1.0/cali_max4;
   calibrate_go = 0;
   statusled=1;
   calibrated=true;
}

/* 
int main()
{
    T1.attach(&samplego, (float)1/Fs);
    cali_button.rise(&calibrate);
    while(1)
    {
        if(sample_go)
        {
            sample_filter();
            sample_go = 0;
        } 
    } // while end   
} // main end
*/
