#ifndef _BIQUADFILTER_H_
#define _BIQUADFILTER_H_


/** A simple Biquad-filter
 * Transposed direct form II adapted from http://www.earlevel.com/main/2003/02/28/biquads/
 *
 * Example:
 * @code
 * #include "mbed.h"
 * #include "biquadFilter.h"        // Require the HIDScope library
 *
 * biquadFilter     myFilter( 0.0009446914586925257 , 0.0018893829173850514 , 0.0009446914586925257 , -1.911196288237583 , 0.914975054072353 );
 * DigitalIn        btn( PTC6 ); 
 
 * double sampleAndFilter()
 * {
 *   // Read digital in from button
 *   return myFilter( btn.read() ? 1 : 0 );
 * }
 * @endcode
*/

class biquadFilter {
        // Constant coefficients of the filter
        const double a1, a2, b0, b1, b2;
        // Storage for Biquad Direct From II
        double v1, v2;
    public: 
        /**
         * Initialize the filter, normalized to 'a0'
         *         b0 + b1 z^-1 + b2 z^-2
         * H(z) =  ----------------------
         *          1 + a1 z^-1 + a2 z^-2
         *
         * @param const double a1
         * @param const double a2
         * @param const double b0
         * @param const double b1
         * @param const double b2
         */
        biquadFilter( const double, const double, const double, const double, const double );
        
        /**
         * Execute one computational step and return the output
         * @param u : double representing the input
         * @return y : double representing the output
         */ 
        double step( double );
};

#endif
