#include "biquadFilter.h"

biquadFilter::biquadFilter( const double a1_, const double a2_, const double b0_,  const double b1_, const double b2_ ) : 
    a1(a1_), a2(a2_), b0(b0_), b1(b1_), b2(b2_), v1(0), v2(0) {};

double biquadFilter::step( double u ) {
    
    double v = u - a1*v1 - a2*v2;
    double y   = b0*v + b1*v1 + b2*v2;
    v2  = v1;
    v1  = v;
    return y;
    
};
