/* mbed Microcontroller Library
 * Copyright (c) 2006-2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
#include "mbed.h"
#include "BLE.h"
 
BLE        ble;         // Bluetooth Low Energy device: Advertising mode
BLE        ble_Scan;    // Bluetooth Low Energy device: Scan mode
DigitalOut led1(LED1);  // Led on Nucleo Board

// Change your device name below
const char DEVICE_NAME[] = "Nucleo_test";

#define T 50               // Threshold for Beacon RSSI
#define UUID 0x00FF        //Beacon UUID
const uint16_t uuid16_list[] = {UUID};
 
// Control Beacon read
static int beacon = 0; 

void periodicCallback(void)
{
    led1 = !led1; /* Do blinky on LED1 while we're waiting for BLE events */
}
 
void advertisementCallback(const Gap::AdvertisementCallbackParams_t *params) { 
    
if (params->peerAddr[0] == 0xB2) {      // Control last bytes of Beacon Address -> Address Beacon 1 is 00 07 80 15 6E B2
    
    if (abs(params->rssi) <= T) {          
    
    printf("Beacon_1: [%02x %02x %02x %02x %02x %02x] rssi %d\r\n",     // Display Beacon Address and relative RSSI
           params->peerAddr[5], params->peerAddr[4], params->peerAddr[3], params->peerAddr[2], params->peerAddr[1], params->peerAddr[0],
           params->rssi);               
    
    beacon = 1; 
    }      
}
    
if (params->peerAddr[0] ==  0xA8) {     // Control last bytes of Beacon Address -> Address Beacon 2 is EE 45 56 1C D0 A8
    
    if (abs(params->rssi) <= T) {           
    printf("Beacon_2: [%02x %02x %02x %02x %02x %02x] rssi %d\r\n",     // Display Beacon Address and relative RSSI
         params->peerAddr[5], params->peerAddr[4], params->peerAddr[3], params->peerAddr[2], params->peerAddr[1], params->peerAddr[0],
         params->rssi);
    
    beacon = 2; 
    }
}
           
if (params->peerAddr[0] == 0x46) {      // Control last bytes of Beacon Address -> Address Beacon 3 is 00 07 80 15 79 46
    
    if (abs(params->rssi) <= T) {       
    printf("Beacon_3: [%02x %02x %02x %02x %02x %02x] rssi %d\r\n",     // Display Beacon Address and relative RSSI
         params->peerAddr[5], params->peerAddr[4], params->peerAddr[3], params->peerAddr[2], params->peerAddr[1], params->peerAddr[0],
         params->rssi);
         
    beacon = 3;
    }
}  
    
}

/* Optional: Restart advertising when peer disconnects */
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    BLE::Instance().gap().startAdvertising();
}

 void bleInitComplete(BLE::InitializationCompleteCallbackContext *context)
{   
    // Set up the advertising flags. Note: not all combination of flags are valid
    // BREDR_NOT_SUPPORTED: Device does not support Basic Rate or Enchanced Data Rate, It is Low Energy only.
    // LE_GENERAL_DISCOVERABLE: Peripheral device is discoverable at any moment
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);

    // Put the device name in the advertising payload
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
  
    /* Optional: add callback for disconnection */
    ble.gap().onDisconnection(disconnectionCallback);
    
    // The Service Data data type consists of a service UUID with the data associated with that service.
    // We will encode the number of beacon received
    uint8_t service_data[2];
    service_data[0] = UUID & 0xff;
    service_data[1] = beacon & 0xff;
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::SERVICE_DATA, (uint8_t *)service_data, sizeof(service_data));  
  
    // It is not connectable as we are just boardcasting
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_NON_CONNECTABLE_UNDIRECTED);

    //Send out the advertising payload every 1000ms
    ble.gap().setAdvertisingInterval(100);
}

void bleScanInitComplete(BLE::InitializationCompleteCallbackContext *context) {
            
    ble_Scan.gap().setScanParams(50 /* scan interval */, 25 /* scan window */, 1);
            
}
 
 
int main(void)
{
    led1 = 1;
    Ticker ticker;
    ticker.attach(periodicCallback, 1);     // Debug Periodic Callback
    
     BLE &ble = BLE::Instance();
     BLE &ble_Scan = BLE::Instance();

int status = 1; 

     /* Infinite loop waiting for BLE events */
     while (true) {   
     switch (status) {
      case(0):
      
      // Advertising mode
      
           printf("Advertising mode 0\r\n");
           ble.init(bleInitComplete);
           ble.gap().startAdvertising();
           wait(1);
           ble.gap().stopAdvertising();
           status = 1;
           NVIC_SystemReset(); 
           break;
     case(1): 
     
     // Scan mode
     
           printf("Scan mode 1\r\n");
           ble_Scan.init(bleScanInitComplete);
           ble_Scan.gap().startScan(advertisementCallback);
           wait(1);
           status = 0;
           break;
          }
        
     /* Save power while waiting for callback events */
    ble.waitForEvent();
    ble_Scan.waitForEvent();
    }
}
