
#include "mbed.h"

#define TIMER0_NUM_COUNTDOWNTIMERS  25

// status definition:
// 0            the timer has expired
// 1            10 ms Timer
// 2            Sekunden Timer
// 3            Minuten Timer
// 4            Stunden Timer
// 0xFF         Free timer


class timer0 {
  private:
      
    struct timerStruct
    {
      unsigned char status;           // siehe Beschreibung
      unsigned int count_timer;       // count down Zähler
    } CountDownTimers[TIMER0_NUM_COUNTDOWNTIMERS];    
    
    struct tm t;        // Struktur Datum & Zeit
    
    Ticker ticker;

  public:

    uint16_t ms;        // Zähler für milli Sekunden
    uint8_t sec;        // Zähler für die Sekunden
    uint8_t min;
    uint8_t hours;

    time_t seconds;     // Sekunden
                
    timer0();
    void func(void);
    void get_time_stamp(uint8_t *tarray,uint16_t *millis);
    uint8_t AllocateCountdownTimer (void);
    void RemoveCountdownTimer(uint8_t timer);
    uint8_t GetTimerStatus(uint8_t timer);
    uint16_t GetTimerZeit(uint8_t timer);
    void SetCountdownTimer(unsigned char timer, unsigned char status, unsigned short value);
    void Set_t(uint8_t * data);
};