
#ifndef MONITOR_H
#define MONITOR_H

#include <string.h>
#include "mbed.h"
#include "MODSERIAL.h"

#define COM_LINE_LEN 100

#define MEM_SIZE       256
#define TARGET_SECTOR  28


namespace mbed
{

class monitor
{
private:


public:

    char com_line[COM_LINE_LEN];            // Aktuelle Eingabezeile
    uint8_t ComLinePtr, ComLineTop;         // Cursor Position und Zeilenlänge

    uint8_t cr_flag;

    uint16_t status[8];

    unsigned char byte_code[30];            // das Telegramm wird hier abgelegt
    uint32_t adr;

    char buffer[100];

    char fname[20];
    FILE *fp;

    monitor(void);
    uint8_t _atoi(char c);
    void parser (char *ptr);

    void get_line(void);
    void get_ch (void);

    void mdate(void);
    void dump(void);
    void flash(void);
    void help(void);
    void in(void);
    void out(void);
    void soft_reset(void);
    void rgb(void);
    void mtime(void);

};

} // namespace mbed

#endif
