
//---------------------------------------------------------------------------
// Modul...: MON.CPP    
// Chip....: iox.mini
// 
//---------------------------------------------------------------------------
// Author..: Reinhold Schäfer
// Date....: 2016.01.23
// http....: //www.microsps.net
//---------------------------------------------------------------------------
#include <stdarg.h>
#include <ctype.h>
#include "mbed.h"
#include "mon.h"
#include "MODSERIAL.h"
#include "timer0.h"

extern MODSERIAL pc;                       // definiert in main
extern timer0 down_timer;                  // Timer für Zeitsteuerung, definiert in main

extern DigitalOut out1;
extern DigitalOut out2;
extern DigitalOut out3;
extern DigitalOut out4;   

#define COMMAND_MAX    5
#define COMMAND_LEN    7
                                             // "DUMP","HELP","SET","TIME"}; 
const char command[COMMAND_MAX][COMMAND_LEN] = {"DUMP","HELP","SET","TIME"};

//-----------------------------------------------------------------------------
// constructor

monitor::monitor(void)
{
    uint8_t i;
    
    for (i = 0; i < MON_LINE_LEN; mon_line[i++] = 0);
    MonLinePtr = 0;
}  

//---------------------------------------------------------------------------
//
//   Function name :    PARSER
//
//   Returns :          none
//
//   Parameters :       none
//
//   Purpose :          wertet die Eingangszeile aus und verzweigt zum gewünschten 
//                      Programm
//
//---------------------------------------------------------------------------
void monitor::parser (void)
{
  uint8_t i, ch, tch, top, bottom, len;
  int8_t res;

  // Zuerst wird der erste Buchstabe aus dem Eingabestring mit den ersten 
  // Buchstaben aus der Befehlstabelle verglichen                         

  bottom = 0;                                        // untere Suchgrenze 
  top = COMMAND_MAX;                                 // obere Suchgerenze 
  ch = mon_line[0];                            // hole erstes Suchzeichen
  
  do 
  {
        i = (top + bottom) >> 1;    // suche in der Mitte des Feldes beginnen
        tch = command [i][0];                     // Vergleichszeichen laden 
        if (tch == ch) break;                             // Zeichen gefunden 
        if (tch > ch) top = i;                           // nach unten suchen 
        else bottom = i;                                  // nach oben suchen 
        if (bottom != 0 && top == bottom + 1) break;   // kein Buchstabe gef.
  
  } while (i > 0 && i < COMMAND_MAX - 1);

  if (tch != ch)
  {
        pc.printf("\nParser Kommando nicht gefunden\n");
        return;                              // Kommando nicht gefunden wurde 
  }
  
  // das erst Wort soll von den Übergabeparametern isoliert werden        
  
  for (i = 0; mon_line[i] != ' ' &&  mon_line[i] != 0; i++);
  len = i;

  
  if (i == 0) return;

  // die Übergabparameter ermitteln und in als Indexzeiger in            
  // 'ComLinePtr' abspeichern                                            

  for ( ; mon_line[i] == ' ' && mon_line[i] != 0; i++);
  MonLinePtr = i;
  
  // die binäre Suche nach den restlichen Zeichen wird hier fortgesetzt 

  do
  {
        i = (top + bottom) >> 1;                 // berechnen des Suchplatzes
        //printf_P (PSTR("\n\rVergleich 1 com_line = [%s] und Länge = [%d]"),com_line,len);
        //strcpy_P (temp, &command[i][0]);
        //printf_P (PSTR("\n\rVergleich 2 command[i] = [%s] und Index = [%d]"),temp,i);
        res = strncmp(mon_line, &command[i][0], len);
        //printf_P (PSTR("\n\rVergleich 3 res = [%d]"),res);
        if (res == 0) break;                       // Zeichen gefunden 
        if (res > 0) 
            bottom = i;                            // nach unten suchen
        else 
            top = i;                               // nach oben suchen
        if (bottom != 0 && top == bottom + 1) break;
  
  } while (i > 0 && i < COMMAND_MAX - 1);

  
  if (res) 
  {
        pc.printf("\nParser Kommando nicht gefunden.\n");
  }
  else 
  {
        pc.printf("\nAufruf von Funktion %d",i);
        
        // "CLCD","DUMP","HELP","SET","TIME"};        
        
        switch(i)                       // Programmaufruf
        {
          case  0: dump();      break;
          case  1: help();      break;
          case  2: set();       break;
          case  3: time();      break;
        }                                   
  }
}

//---------------------------------------------------------------------------
//
//  Function name : monitor
//
//  Returns :       none
//
//  Parameters :    none
//
//  Purpose :       Monitor für die Benutzereingabe
//
//---------------------------------------------------------------------------
void monitor::monPC(void)
{
    uint8_t i;
    char ch;

    monLine();
    if (cr_flag)                   // Neue Eingabezeile  
    {
        if (mon_line[0] != 0)
        {
            // Zeichenkette in Großbuchstaben umwandeln
            for (i = 0; mon_line[i] != 0; i++)
            {
                ch = mon_line[i];
                ch = toupper(ch);                          // Nur Großbuchstaben 
                mon_line[i] = ch;
                //pc.printf(("\n[%02x] %c"),ch,ch);                
                if (ch == ' ') i = MON_LINE_LEN;
            }
            
            // pc.printf("\n monitor %s", mon_line);        // zum Testen => später wird der parcer aufgerufen
            parser();                                       // Parcer wird aufgerufen
        }
 
        for (i=0; i < MON_LINE_LEN; mon_line[i++] = 0);
        MonLinePtr = 0;                         
        cr_flag = 0;
  }     
}

//---------------------------------------------------------------------------
//
//  Function name : mon_line
//
//  Returns :       none
//
//  Parameters :    none
//
//  Purpose :       
//      Wird periodisch in unregelmäsigen Abständen aufgerufen und ermittelt,    
//      ob weitere Zeichen von der Schnittstelle empfangen und die Eingabe      
//      mit Carrige Return abgeschlossen wurde. Sollte dies der Fall sein,      
//      wird das CR_FLAG gesetzt. Auch Editierfunktionen werden in diesem      
//      Rahmen behandelt.                               
//
//---------------------------------------------------------------------------

void monitor::monLine (void)
{
    int ch;
  
    if (pc.readable() == false) return;     // kein Zeichen vorhanden 
    
    if (MonLinePtr >= 40)                   // Zeilenüberlauf ?  
    {
        cr_flag = 1;
        return;
    }

    ch = pc.getc();                             // Hole das Zeichen  
    //pc.printf("\nmon_line: %c [%02x]",ch,ch);   // nur zum Test
  
    switch(ch) 
    {
        //case ESC: esc_flag = 1;           // Sonder Stringkommandos 
        //  break;

        case '\r':                          // CARRIAGE RETURN  
            cr_flag = 1;
            break;

        case '\n':                          // LF empfangen
            cr_flag = 1;
            break;

        default:                            // Normales Zeichen  
            if (~iscntrl(ch)) 
            {
                mon_line[MonLinePtr] = ch;  // Zeichen einfuegen 
                MonLinePtr++;
                // pc.putc(ch);
            }
            break;

    }   // Ende SWITCH 
}

//-----------------------------------------------------------------------------
// monitor Aufruf damp

void monitor::dump(void)
{
  pc.printf("\nin dump");
}   

//-----------------------------------------------------------------------------
// monitor Aufruf help

void monitor::help(void)
{
  pc.printf("\n -- help ------------------------");
  pc.printf("\n clcd val >> lcd Kontrast");
  pc.printf("\n set index [val] >> Ausgang setzen");
  pc.printf("\n time [std min sek tag monat jahr]");   
  pc.printf("\n"); 
  pc.printf("\n");
}


//-----------------------------------------------------------------------------
// monitor Aufruf set

void monitor::set(void)
{
    int n, pos, val;

    pos = 0;
    val = 0;
    
    n = sscanf(&mon_line[MonLinePtr],"%d %d",&pos,&val);
    
    if ((pos < 0) || (pos > 4)) n = -1;
    if ((val < 0) || (val >1)) n = -1;
    
    switch (n)
    {
      case -1: 
          pc.printf("\nbitte [Ausgang] [Wert] angeben");
          pc.printf("\n Ausgang >> 1 bis 6");
          pc.printf("\n Wert  >> 0 = inaktiv, 1 = aktiv");
          break;
            
          default:
                    switch (pos)
                    {
                        case 1:
                            pc.printf("\n Ausgang 1 = %d",val);
                            out1 = val;
                            break;
                        case 2:
                            pc.printf("\n Ausgang 2 = %d",val);
                            out2 = val;
                            break;
                        case 3:
                            pc.printf("\n Ausgang 3 = %d",val);
                            out3 = val;
                            break;
                        case 4:
                            pc.printf("\n Ausgang 4 = %d",val);
                            out4 = val;
                            break;                    
                    }
                    break;
     } // end switch
}

//-----------------------------------------------------------------------------
// monitor Aufruf time

void monitor::time(void)
{
    int sek, min, std, day, month, year, n;    
    
    sek     = 0;   
    min     = 0;    
    std     = 0;
    day     = 0;
    month   = 0;
    year    = 0; 
    
    n = sscanf(&mon_line[MonLinePtr],"%d %d %d %d %d %d",&std, &min, &sek, &day, &month, &year);

    switch (n)
    {
        case -1 :  // keine Zeichenübergabe
        case  0 :  // keine Zeichenübergabe
     
                strftime(buffer, 40, "%a, %d.%m.%Y %H:%M:%S", localtime(&down_timer.seconds));
                pc.printf("\nTime = %s\n", buffer);
                break;
                
        case 1 :   // std
        case 2 :   // min
        case 3 :   // sek
        case 4 :   // tag
        case 5 :   // mon
        case 6 :   // jahr
                            
                if (sek > 59) sek = 59;
                if (sek < 0)  sek = 0;
                buffer[0] = (uint8_t)sek;;

                if (min > 59) min = 59;
                if (min < 0) min = 0;
                buffer[1] = (uint8_t)min;
                
                if (std > 23) std = 23;
                if (std < 0) std = 0;
                buffer[2] = (uint8_t)std;

                if (day > 31) day = 31;
                if (day < 0)  day = 0;
                buffer[3] = (uint8_t)day;;

                if (month > 12) month = 12;
                if (month < 0) month = 0;
                buffer[4] = (uint8_t)month;
                
                if (year > 2100) year = 2100;
                if (year < 2000) year = 2000;
                buffer[5] = (uint8_t)(year - 1900);


                down_timer.Set_t((uint8_t *)buffer);
 
                strftime(buffer, 40, "%a, %d.%m.%Y %H:%M:%S", localtime(&down_timer.seconds));
                pc.printf("\nnew Time = %s\n", buffer);    
                break;
    }
}

