// Hardware:    IOX.mini
// Projekt:     Galliker LC4 tore
// CPU:         LPC1768
// Modul:       main.cpp
// Anwendung:   Torsteuerung

#include "mbed.h"
#include "main.h"
#include "timer0.h"
#include "mon.h"
#include "MODSERIAL.h"

struct di_struct 
{
    bool  aktiv;      // Flag zur Steuerung
    bool  old;        // alter Wert vom Eingang für Flankenerkennung 
    bool  flag;       // Flag für Zeitsteuerung
};

#define AUS 1
#define EIN 0

DigitalOut led_in1(LED2,AUS);
DigitalOut led_in2(LED3,AUS);
DigitalOut led_in3(LED4,AUS);
DigitalOut led_in4(LED5,AUS);

DigitalOut led_out1(LED7,AUS);  // die LED's out2 bis out4 sind direkt den Ausgängen zugeordnet

DigitalOut led1(LED1,AUS);
DigitalOut led6(LED6,AUS);

DigitalOut out1(OUT1,0);        // max 500mA schaltet gegen GND
DigitalOut out2(OUT2,0);
DigitalOut out3(OUT3,0);
DigitalOut out4(OUT4,0);

DigitalIn IN_1(IN1);            // 0 oder 24V
DigitalIn IN_2(IN2);
DigitalIn IN_3(IN3);
DigitalIn IN_4(IN4);
        
MODSERIAL pc(TXD, RXD);         // tx, rx
timer0 down_timer;              // Timer für Zeitsteuerung

monitor mon;

//=====================================================================================
// Globale Variablen

bool in, flag_ablauftimer;
struct di_struct in1;            // Eingang 1
struct di_struct in2;            // Eingang 2

//------------------------------------------------------------------------------------

int main() {
    
    pc.baud(115200);

    pc.printf("\nGalliker LC4 tore V0.0_a");
    pc.printf("\n build at "__DATE__"  "__TIME__" ");    

    in1.old = 1;        // 1 im Ruhezustand
    in2.old = 1;        // 1 im Ruhezustand    

    in1.flag = false;
    in2.flag = false;

    flag_ablauftimer = false;
              
    down_timer.SetCountdownTimer(0,1,500); // Timer für LED
    down_timer.SetCountdownTimer(1,1,500); // Timer für Eingänge lesen
    
    while(1) {
         
        mon.monPC();          // Eingaben abfragen und auswerten
        
        //  RS485_BUS.execute();  // RS485 Bus
        
        //--------------------------------------------------------------------------
        // LED für Statusanzeige              
       
        if (down_timer.GetTimerStatus(0) == 0)
        {  
            down_timer.SetCountdownTimer(0,1,500);    // alle 500ms 
            led1 = !led1;
        } 
        
        //-------------------------------------------------------------------------------
        // Eingänge abfragen und Aktionen ableiten
        
        if (down_timer.GetTimerStatus(1) == 0) 
        {
            down_timer.SetCountdownTimer(1,1,10); // ms Timer * 10 => ergibt 10 ms  
          
            //==============================================================================================
            // Impuls auf IN1 = OUT1 für 1s auf EIN
            //
            // Wenn Impuls auf IN0, dann wird ein Ablauftimer aktiviert (1,5h) 
            // - nach Ablauf dieser Zeit = OUT1 für 1s auf EIN 
            // - sofern nicht vorher ein Impuls von IN1 registriert wurde
            // 
            // Ablauftimer ist Timer 4

            in = IN_1;
            if (in != in1.old)       // negative Flanke an IN1
            {
                in1.old = 0;  
                led_in1 = EIN;
                out1 = 1;
                led_out1 = EIN;
                down_timer.SetCountdownTimer(2,1,1000);  // 1 Sekunde
                in1.flag = true;
                down_timer.SetCountdownTimer(4,3,90);    // 1,5 Stunden
                flag_ablauftimer = true;
                out3 = 1;                                // LED Taster (Ablaufzeit aktiviert)
                pc.printf("\n negative Flanke IN1 \n");
          
            }
            
            if (in && !in1.old)      // positive Flanke an IN1
            {
                in1.old = 1;
                led_in1 = AUS;
                pc.printf("\n positve Flanke IN1 \n");
            }
            
            if (in1.flag && (down_timer.GetTimerStatus(2) == 0))
            {
               in1.flag = false;
               out1 = 0;
               led_out1 = AUS; 
            }
            
            //==============================================================================================
            // Impuls auf IN2 = OUT2 für 1s  auf EIN
            //

            in = IN_2;
            if (in != in2.old)       // negative Flanke an IN2
            {
                in2.old = 0;  
                led_in2 = EIN;
                out2 = 1;
                down_timer.SetCountdownTimer(3,1,1000);     // 1 Sekunde
                in2.flag = true;
                flag_ablauftimer = false;                   // Ablaufzeit wird unterbrochen
                pc.printf("\n negative Flanke IN2 \n");
            }
            
            if (in && !in2.old)      // positive Flanke an IN2
            {
                in2.old = 1;
                led_in2 = AUS;
                pc.printf("\n positve Flanke IN2 \n");
            }
            
            if (in2.flag && (down_timer.GetTimerStatus(3) == 0))
            {
               in2.flag = false;
               out2 = 0; 
            } 
            
            //==============================================================================================
            // prüfen ob Ablaufzeit vorbei, falls ja, die Ausgang out2 für eine Sekunde auf 1 setzen
            //  

            if (flag_ablauftimer && (down_timer.GetTimerStatus(4) == 0))
            {
                flag_ablauftimer = false;
                out2 = 1;
                out3 = 0;                                // LED Taster (Zeit abgelaufen)
                down_timer.SetCountdownTimer(3,1,1000);  // 1 Sekunde
                in2.flag = true;
            }            
        
        }
                      
    } // end while(1)
}
