
#include "mbed.h"
#include "MODSERIAL.h"

// Schnittstelle für den H-Bus
#define RS485_TX2   P2_0
#define RS485_RX2   P2_1
#define RS485_DIR2  P1_4

class rs_485 {

  private:

    Timer   timeout;        // define debounce timer
    Timeout timeout_out;
    
    int tx_timeout1;
    int tx_timeout2;
     
    bool send_end_flag;     // Flag für Telegrammende
    uint8_t rs_aktiv;       // 0 inaktiv auf Empfang
                            // 1 aktiv auf Empfang
                            // 2 aktiv im Sendemodus
    uint8_t rs_aktiv_old;
    uint8_t t_array[4];
    int     zeit;
      
  public:

    struct Message {
    uint8_t     STX;                // Start byte
    uint8_t     source;             // Absender Adresse
    uint8_t     dest;               // Ziel Adresse 
    uint8_t     len;                // Length of data field in bytes   
    uint8_t     data[8];            // Data field
    uint8_t     CRC;                // CRC
    uint8_t     ETX;                // Telegramm Ende
    uint8_t     h;
    uint8_t     m;
    uint8_t     s;
    uint16_t    ms;
    uint8_t     count;              // interner Zähler
    uint8_t     sm;                 // interne Steuerung ( state maschine )
    uint8_t     error; 
    };

    Message msg_out;
    Message msg_in; 
       
    rs_485();
   
    void isr_timeout(void);
    void txEmpty(MODSERIAL_IRQ_INFO *q);
    uint8_t get_crc(uint8_t *pbuffer, uint8_t count);
    void msg_print(Message msg);
    void write(uint8_t *data);
    void execute(void);
    void send(void);
    void receive(void);
     
};