// Version 1.0   erstellt am 22.08.2015
//
// IN1 auf 0 = OUT5+6 AUS
// IN1 auf 1 = OUT5+6 EIN plus 5 Sekunden Ausschaltverzögerung

#include "mbed.h"
#include "main.h"
#include "timer0.h"
#include "monitor.h"
#include "MODSERIAL.h"

#define NEED_CONSOLE_OUTPUT 1   // Set this if you need debug messages on the console
                                // mit Debug wird die Programmgröße von 32,8k um ca. 300 Byte vergrößert
                                // dies ist nicht bedeutend, aber auch die Ausführungszeit der Ausgabebefehle
                                // benötigt CPU Zeit
#if NEED_CONSOLE_OUTPUT
  #define DEBUG(...) { pc.printf(__VA_ARGS__); }
#else
  #define DEBUG(...)    // nothing
#endif                  // #if NEED_CONSOLE_OUTPUT 

//------------------------------------------------------------------------------
// Anlegen von Klassen

timer0 down_timer;                              // Zeitsteuerung
MODSERIAL pc(USBTX, USBRX);                     // tx, rx

monitor mon;

Timer t;                                        // Zeitmessung für Entprellen

//------------------------------------------------------------------------------
// Zuordnung von Eingängen und Ausgängen

DigitalOut LED(PTE30);

DigitalOut OUT1(PTC6);      // nicht belegt
DigitalOut OUT2(PTC5);      // nicht belegt
DigitalOut OUT3(PTC4);      // nicht belegt
DigitalOut OUT4(PTC3);      // Türöffner                                schaltet gegen GND max. 500mA
DigitalOut OUT5(PTC2);      // nicht belegt (Summer)
DigitalOut OUT6(PTC1);      // Relais: Tür / Torsteuerung               Relais Kontakt als Ausgang

DigitalIn IN1(PTC7);        // Taster Türöffnersignal                   24V oder 1 ist der Ruhezustand
DigitalIn IN2(PTD4);        // nicht belegt  
DigitalIn IN3(PTD5);        // nicht belegt                  
DigitalIn IN4(PTD6);        // nicht belegt                             
DigitalIn IN5(PTD7);        // nicht belegt 

DigitalInOut rst(PTA4);     //Connect this to the reset pin

//------------------------------------------------------------------------------
// Globale Variablen

bool in;

struct di_struct in1;      // Eingang 1


//------------------------------------------------------------------------------
//

int main()
{
    rst.input();     // SW watchdog ist derzeit nicht erforderlich
    
    //------------------------------------------------------------------------------
    // RS232 Schnittstellt welche auf den CMSIS-DAP (USB Port) weitergeleitet wird
    //
    pc.baud(115200);
    pc.printf("\n N1380 V1.0 was compiled on %s  %s \n", __DATE__,__TIME__);


    //--------------------------------------------------------------------
    //  Anfangswerte setzen

    in1.old = 1;        // 1 im Ruhezustand      
    OUT4 = 0;
    OUT6 = 0; 
      
    //--------------------------------------------------------------------
    // Softwaretimer für die Zeitsteuerung anlegen

    down_timer.SetCountdownTimer(0,1,500);      // 1 ms Timer * 500 => ergibt 500 ms für die LED
    down_timer.SetCountdownTimer(1,1,10);       // 1 ms Timer * 10  => ergibt 10 ms für die Tasterabfrage
    
    //--------------------------------------------------------------------
    // Schleife fuer die Datenerfassung

    while(1) 
    {
        //-------------------------------------------
        // Prüfen ob Zeichen eingegeben wurden
        // wird in der aktiven Version ausgeblendet, ist nur zum Testen
        
        mon.get_line();

        //-------------------------------------------
        // timer 0 steuert die LED auf dem Board mit der Takrate 0,5 Sekunden

        if (down_timer.GetTimerStatus(0) == 0) 
        {
            down_timer.SetCountdownTimer(0,1,500);
            LED = !LED;
            
        }

        //-------------------------------------------
        // Eingänge abfragen und Aktionen ableiten
        // down

        if (down_timer.GetTimerStatus(1) == 0) 
        {
            //down_timer 1 mit 10 ms gesetzt
            down_timer.SetCountdownTimer(1,1,10);

            //------------------------------------------------
            // IN1  Nottaster auswerten, null im Ruhezustand
            // wird mit der negativen Flanke aktiviert
            // das Signal muss mindestens 10ms anliegen, damit es akzeptiert wird
        
            in = IN1;
            
            if(!in && in1.old)       // Öffner im Ruhezustand 24 V >> durch Drücken wird eine neg. Flanke erzeugt
            {                        
                in1.old = 0;
                DEBUG("\n negative Flanke IN1 \n");
            }

            if (in && !in1.old)      // Öffner im Ruhenzustand 24 V >> durch Rückstellen enteht eine pos. Flanke
            {
                in1.old = 1;
                down_timer.SetCountdownTimer(3,1,5000);  // Zeit für Abschaltverzögerung auf 5 Sekunden setzen
                DEBUG("\n positve Flanke IN1 \n");
            }

            //---------------------------------------------------------------------------------------------------------------------------------------
            // Die Eingänge sind nun gelesen, jetzt kommt das Steuern der Ausgänge
            //
            
            //------------------------------------------------
            // IN1 auf 0 = OUT4+6 AUS
            // Nach Ablauf der Ausschaltverzögerung wird der Ausgang wieder auf 0 geschaltet
            
            if (!in1.old && (down_timer.GetTimerStatus(3) == 0)) 
            {          
                OUT4 = 0;
                OUT6 = 0;
            }

            //------------------------------------------------
            // IN1 auf 1 = OUT4+6 EIN plus 5 Sekunden Ausschaltverzögerung 
            // Die Ausschaltverögerung wirkt auf das Ausschalten nicht auf das Einschalten
                       
            if (in1.old)
            {   
                OUT4 = 1;
                OUT6 = 1;
            }            
            
        } // end if (downtimer ...
        
    } // end while

} // end main

