/**
 * Copyright 2014 Nordic Semiconductor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 */

#define LOG_LEVEL_INFO

/**
 * Warning: remove LOG_LEVEL_* defines in production for major power savings.
 *
 * Defining a log level will set up a serial connection to use for logging.
 * This serial connection sets up a timer prohibiting the mbed chip
 * from entering low power states, drawing ~1.4mAh instead of ~20µAh with logging disabled.
 */

#include "Puck.h"

Puck* puck = &Puck::getPuck();

// Sample Gatt characteristic and service UUIDs
const UUID SAMPLE_GATT_SERVICE = stringToUUID("bftj http post  ");
const UUID SAMPLE_GATT_CHARACTERISTIC = stringToUUID("bftj post body  ");

int main(void) {
    // Add the Gatt characteristic
    int characteristicValueLength = 1;
    puck->addCharacteristic(
            SAMPLE_GATT_SERVICE,
            SAMPLE_GATT_CHARACTERISTIC,
            characteristicValueLength,
            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);

    // Initialize the puck
    puck->init(0xFEED);

    // Set the initial value of the characteristic
    uint8_t new_value = 42;
    puck->updateCharacteristicValue(SAMPLE_GATT_CHARACTERISTIC, &new_value, characteristicValueLength);

    // Let the puck do its thing
    while(puck->drive());
}