/*LAB_SERVO*/
#include "mbed.h"

PwmOut servo(A0);
PwmOut pwm1(D7);

DigitalOut myled(LED1);
DigitalOut led1(D13);
DigitalOut led2(D12);

Ticker timer1;
void timer1_interrupt(void);

void init_TIMER(void);
void init_IO(void); 
void init_PWM(void);

float servo_duty = 0.058;   //0.079 +(0.084/180)*angle, -90<angle<90
bool servo_flag = false;

int main() 
{
    init_TIMER();
    init_IO();
    init_PWM();
    
    while(1)
    {
        servo_duty += 0.00007;
        
        if(servo_flag == true)
        {
            servo.write(servo_duty);
            servo_flag = false;
        }
        
        if(servo_duty > 0.1)
            break;
        
    }

}

void timer1_interrupt(void)
{
    servo_flag = true;
}

void init_TIMER(void)
{
    timer1.attach_us(&timer1_interrupt, 10000);//10ms interrupt period (100 Hz)
}

void init_IO(void)
{
    led1 = 0;
    led2 = 1;
}

void init_PWM(void)
{
    servo.period_ms(20);        //pwm period 20ms
    servo.write(servo_duty);
    //pwm1.period_us(50);
    //pwm1.write(0.5);
    //TIM1->CCER |= 0x4;
}
