/* main.cpp */
/* Copyright (C) 2015 nimbelink.com, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 115200 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(USBTX, USBRX);
Serial skywire(PA_9, PA_10);  //Nucleo Boards
//Serial skywire(PTC17, PTC16);    //K64 FRDM

DigitalOut myled(LED1);

DigitalOut skywire_en(PA_6);    //Nucleo
DigitalOut skywire_rts(PA_7);

//DigitalOut skywire_en(PTD3);    //K64 FRDM
//DigitalOut skywire_rts(PTD2);

char c;

int main()
{
    skywire.baud(115200);
    pc.baud(115200);
    skywire_rts=0;
    pc.printf("Hello World !\n");
    myled=0;
    skywire_en=0;
    wait(1);
    skywire_en=1;
    wait(1);

    myled=1;
    while(1) {
        if(skywire.readable()) {
            c = skywire.getc();
            //skywire.putc(c);
            pc.putc(c);
        }
        if(pc.readable()) {
            c = pc.getc();
            skywire.putc(c);
            //pc.putc(c);
        }
    }
}


