/* NetworkSocketAPI Example Program
 * Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "LWIPInterface.h"
#include "NSAPITests.h"

LWIPInterface iface;

Ticker blinker;
DigitalOut led(LED_GREEN);
void blink() {
    led = !led;
}

int main()
{
    blinker.attach(blink, 0.5);

    int result = iface.connect();
    if (result) {
        printf("Interface failed to connect with code %d\r\n", result);
        while (1);
    }

    nsapi_tests("LWIPInterface Tests", &iface, "0.0.0.0", 4000);

    result = iface.disconnect();
    if (result) {
        printf("Interface failed to disconnect with code %d\r\n", result);
        while (1);
    }

    while(1);
}
