/* NetworkSocketAPI Example Program
 * Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "BSDInterface.h"
#include "TCPSocket.h"
#include <stdio.h>

BSDInterface iface;
TCPSocket sock(&iface);

int main()
{
    printf("NetworkSocketAPI Example\r\n");

    const char *ip = iface.getIPAddress();
    const char *mac = iface.getMACAddress();
    printf("IP Address is: %s\r\n", (ip) ? ip : "No IP");
    printf("MAC Address is: %s\r\n", (mac) ? mac : "No MAC");

    sock.open("time-a.nist.gov", 37);
    printf("time-a.nist.gov resolved to: %s\r\n", sock.getIPAddress());

    unsigned char recieved[100] = {0};
    int32_t size = 0;
    size = sock.recv(recieved, sizeof(recieved));

    sock.close();

    printf("Recieved: %d bytes, %02x%02x%02x%02x\r\n", size,
            recieved[0], recieved[1], recieved[2], recieved[3]);
    printf("NetworkSocketAPI Example Finished\r\n");
}
