/* BSD implementation of NetworkInterfaceAPI
 * Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef BSD_INTERFACE_H
#define BSD_INTERFACE_H

#include "EthernetInterface.h"


/** BSDInterface class
 *  Implementation of the NetworkInterface for BSD sockets
 */
class BSDInterface : public NetworkInterface
{
public:
    // Implementation of NetworkInterface
    virtual const char *getIPAddress();
    virtual const char *getMACAddress();

    virtual int32_t getHostByName(const char *host, char *ip);

    virtual SocketInterface *createSocket(ns_protocol_t proto);
    virtual void destroySocket(SocketInterface *socket);

private:
    // Implementation of the SocketInterface for BSD
    struct BSDSocket : public SocketInterface
    {
        int fd;
        BSDSocket(int fd) : fd(fd) {}

        // Implementation of SocketInterface
        virtual int32_t open(const char *ip, uint16_t port);
        virtual int32_t close();

        virtual int32_t send(const void *data, uint32_t size);
        virtual int32_t recv(void *data, uint32_t size);
    };
};


#endif
