#include "NetCentricApp.h"
#include "mbed.h"
#include "HBridge.h"
#include "PcControls.h"

AnalogIn motorInput(p16);
DigitalOut outSignal(p18);

HBridge motor(p18,p15,p22);


int main() {
    printf("Started NetCentric App\r\n");
    
    MotorController motorController(motor, motorInput);
    MotorControlsPc pcControls(motorController);
    
    NetCentricApp app(pcControls);
    
    USBInit();
    while (true) {
        pcControls.ProcessPcInput((char) motorController.getCurrentAction());
        USBLoop();
        wait(0.001);
    }
}