#ifndef MOTORCONTROLLER_H
#define MOTORCONTROLLER_H

#include "mbed.h"
#include "HBridge.h"

class MotorController {
    public:
        MotorController (HBridge &motor, AnalogIn &motorInput);
        
        void start ();
        void stop ();
        
        void turnLeft ();
        void turnRight ();
        void setPosition (float position);
        
        float getPosition ();
        
        void setCurrentAction (char c);
        char getCurrentAction ();
        
        void setCurrentStatus (char c);
        char getCurrentStatus ();
        
        static const float POSITION_0  = 0.0f;
        static const float POSITION_1  = 0.65f;
        static const float POSITION_2  = 2.55f;
        static const float POSITION_3  = 8.2f;
        static const float POSITION_4  = 14.65f;
        static const float POSITION_5  = 22.3f;
        static const float POSITION_6  = 29.3f;
        static const float POSITION_7  = 41.6f;
        static const float POSITION_8  = 68.5f;
        static const float POSITION_9  = 98.0f;
        static const float POSITION_10 = 100.0f;
        
        static const float MARGIN_PERCENTAGE = 0.013f;
        static const float MARGIN_FIXED = 0.13f;
        
        static const float STATUS_OK = 'o';
        static const float STATUS_STUCK = 's';
    
    private:
        static const int BUFFER_SIZE = 20;
        HBridge &motor;
        AnalogIn &motorInput;
        
        char currentAction;
        char currentStatus;
        
        int bufferCount;
        int bufferIndex;
        float positionBuffer[BUFFER_SIZE];
        
        bool isMotorStuck ();
        void addLatestPosition (float position);
        void CheckMotorStatus ();
};

#endif