#include "mbed.h"
#include "nsdl_support.h"
#include "payload.h"
#include "ColorDetector.h"

#define RESOURCE_ID    "sensor/capsule"

extern Serial pc;
/* stored data for observable resource */
static uint8_t obs_number = 0;
static uint8_t *obs_token_ptr = NULL;
static uint8_t obs_token_len = 0;

ColorDetector *g_detector;
static Payload g_payload;

static bool resourceFullyInitialized = false;

void set_color_detector(ColorDetector *detector) {
    g_detector = detector;
}

void run_color_detector()
{
    if (!resourceFullyInitialized)
        return;
        
    if (obs_number == 0 && obs_token_ptr == NULL)
        pc.printf("ERROR: obs_number: %d, obs_token_ptr: %0x%08x\r\n", obs_number, obs_token_ptr);

    obs_number++;
    
    // Take samples from color detector
    int samples_captured = g_detector->sample();
    
    // If a capsule was detected, a number greater than 0 is returned
    if (samples_captured > 0) {
        // Build payload from color detector buffer
        g_payload.build(g_detector->getBuffer(), samples_captured);
        
        // Send payload to mDS
        int result = sn_nsdl_send_observation_notification(obs_token_ptr, obs_token_len, g_payload.raw_bytes(), g_payload.raw_bytes_size(), &obs_number, 1, COAP_MSG_TYPE_NON_CONFIRMABLE, 0);
        
        pc.printf("Observation send %s. [samples: %d, bytes: %d]\r\n", result == 0 ? "failed" : "succeeded", samples_captured, g_payload.raw_bytes_size());
    }      
}

/* Only GET method allowed */
static uint8_t resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;

    coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

    coap_res_ptr->payload_len = g_payload.raw_bytes_size();
    coap_res_ptr->payload_ptr = g_payload.raw_bytes();

    if(received_coap_ptr->token_ptr)
    {
        if(obs_token_ptr)
        {
            free(obs_token_ptr);
            obs_token_ptr = 0;
        }
        obs_token_ptr = (uint8_t*)malloc(received_coap_ptr->token_len);
        if(obs_token_ptr)
        {
            memcpy(obs_token_ptr, received_coap_ptr->token_ptr, received_coap_ptr->token_len);
            obs_token_len = received_coap_ptr->token_len;
        }
    }

    if(received_coap_ptr->options_list_ptr->observe)
    {
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)malloc(sizeof(sn_coap_options_list_s));
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->observe_ptr = &obs_number;
        coap_res_ptr->options_list_ptr->observe_len = 1;
        obs_number++;
    }

    sn_nsdl_send_coap_message(address, coap_res_ptr);

    coap_res_ptr->options_list_ptr->observe_ptr = 0;
    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);

    resourceFullyInitialized = true;
    
    return 0;
}

int create_color_detector_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(RESOURCE_ID) - 1, (uint8_t*)RESOURCE_ID, 0, 0, 1, &resource_cb, SN_GRS_GET_ALLOWED);
    return 0;
}
