#include "ColorDetector.h"
#include "math.h"


ColorDetector::ColorDetector(GroveColourSensor *sensor, PinName photoresistorPin, float prThreshold, int minNumSamples) 
    :sensor(sensor), photoresistor(photoresistorPin), prThreshold(prThreshold), minNumSamples(minNumSamples), curBufPtr(sample_buf), capturing(false) {
    // Empty
}


int ColorDetector::sample() {
    int retVal = 0;
    
    if (photoresistor < prThreshold) {
        if (curBufPtr - sample_buf < CD_BUFF_LEN) {
            if (capturing == false) {
                capturing = true;
                curBufPtr = sample_buf;
            }
            
            __disable_irq();
            sensor->readBlock(curBufPtr++);
            __enable_irq();
        }
    } else {
        if (capturing == true) {
            capturing = false;
            retVal = curBufPtr - sample_buf;
            
            // If the number of samples is less than the minimum, throw away the samples
            if (retVal < minNumSamples) {
                retVal = 0;
            }
        }
        curBufPtr = sample_buf;
    }
    
    return retVal;
}

RGBC* ColorDetector::getBuffer() {
    return sample_buf;
}