#include "mbed.h"
#include "GroveColourSensor.h"
#include "ColorDetector.h"

/************************
* Modify parameters below
************************/
#define COLOR_SENSOR_SCL I2C_SCL
#define COLOR_SENSOR_SDA I2C_SDA
#define COLOR_SENSOR_PR  A0

#define NUM_RUNS_PER_CAPSULE 20
#define NUM_CAPSULES 5

const char* capsules[] = {
    "decaffeinato_intenso",
    "vivalto_lungo",
    "roma",
    "livanto",
    "arpeggio"
};

/************************
* Stop editing here
************************/

Serial pc(USBTX, USBRX);

int main()
{
    // Gotta speed up the terminal, otherwise takes forever to print samples
    pc.baud(115200);
    
    DigitalOut scl_dummy(I2C_SCL);
    
    // Ensure I2C bus is released by toggling clock (fixes reset errors)
    for (int i = 0; i < 100; i++) {
        scl_dummy = !scl_dummy;
        wait_us(2);
    }
    
    I2C i2c(COLOR_SENSOR_SDA, COLOR_SENSOR_SCL);
    
    GroveColourSensor colorSensor(&i2c);     
    
    colorSensor.powerUp();
    colorSensor.setGain(3);
    colorSensor.setBlockRead();
    
    ColorDetector detector(&colorSensor, COLOR_SENSOR_PR);
    
    int runCount, sampleCount;
    RGBC *buf = detector.getBuffer();
    
    pc.printf("module.exports = {\r\n");
    
    for (int i = 0; i < NUM_CAPSULES; i++) {
        pc.printf("\t\"%s\": [\r\n", capsules[i]);
        
        runCount = 0;
        
        while (runCount < NUM_RUNS_PER_CAPSULE) {
            sampleCount = detector.sample();
            wait(0.001);
            if (sampleCount > 0) {
                pc.printf("\t\t[\r\n");
                
                for (int j = 0; j < sampleCount; j++) {
                    pc.printf("\t\t\t[%u, %u, %u]", buf[j].ch.red, buf[j].ch.green, buf[j].ch.blue);
                    
                    if (j < sampleCount - 1) {
                        pc.printf(",");
                    }
                    
                    pc.printf("\r\n");
                }
                
                pc.printf("\t\t]");
                
                if (runCount < NUM_RUNS_PER_CAPSULE - 1) {
                    pc.printf(",");
                }
                
                pc.printf(" // %d, %d samples taken\r\n", runCount, sampleCount);
                runCount++;
            }
        }
        
        pc.printf("\t]");
        
        if (i < NUM_CAPSULES - 1) {
            pc.printf(",");
        }
        
        pc.printf(" // %s\r\n", capsules[i]);
    }
    
    pc.printf("};");
    
    return 0;
}