#include "mbed.h"
#include "Bumper.hpp"
#include "TargetHitCallback.hpp"
#include "TestTargetManager.hpp"
#include "TargetMissedCallback.hpp"
#include "NerfusTicker.hpp"

int main() 
{
    printf("Start TargetManager manual test\r\n");
    printf("Instruction:\r\n");
    printf("\tNerfusTicker works if target #0 is missed by default and target #1 is always hit\r\n");
    printf("\tBumper works if a target hit is printed when you click the limit switch\r\n");
    printf("\t\tLimit switch connections: C(p5), NO(VCC), NC(GND)\r\n");
    
    PinName bumper_pin_0 = p5;
    PinName bumper_pin_1 = p6;
    
    //Tickers
    NerfusTicker target_timeout_ticker_0;
    NerfusTicker target_timeout_ticker_1;
    std::vector<NerfusTickerInterface*> tickers;
    tickers.push_back(&target_timeout_ticker_0);
    tickers.push_back(&target_timeout_ticker_1);

    TestTargetManager target_manager(tickers);
    
    TargetMissedCallback target_missed_callback_0(target_manager, 0);
    TargetMissedCallback target_missed_callback_1(target_manager, 1);
    target_timeout_ticker_0.init(&target_missed_callback_0);
    target_timeout_ticker_1.init(&target_missed_callback_1);
    
    TargetHitCallback target_hit_callback_0(target_manager, 0);
    TargetHitCallback target_hit_callback_1(target_manager, 1);
    Bumper bumper_0(bumper_pin_0, target_hit_callback_0);
    Bumper bumper_1(bumper_pin_1, target_hit_callback_1);
    
    while(true)
    {
        target_timeout_ticker_0.start(500);
        target_timeout_ticker_1.start(1000);
        wait_ms(750);
        bumper_1.bumped();
        wait_ms(1500);
    }
}
