#include "TestTargetManager.hpp"

#include <cstdio>

TestTargetManager::TestTargetManager(std::vector<NerfusTickerInterface*>& target_timeout_tickers) : 
    target_timeout_tickers(target_timeout_tickers)
{
    
}

void TestTargetManager::execute(const std::vector<uint8_t>& target_info_bytes, int *address)
{
    
}

void TestTargetManager::target_hit(int target_number)
{
    target_timeout_tickers[target_number]->stop();
    std::printf("Target #%d hit after %d ms\r\n", target_number, target_timeout_tickers[target_number]->get_time_ms());
}

void TestTargetManager::target_missed(int target_number)
{
    std::printf("Target #%d missed after %d ms\r\n", target_number, target_timeout_tickers[target_number]->get_time_ms());
}
