#ifndef TEST_TARGET_MANAGER_HPP
#define TEST_TARGET_MANAGER_HPP

#include <vector>
#include "NerfusTickerInterface.hpp"
#include "TargetManagerInterface.hpp"

class TestTargetManager : public TargetManagerInterface
{
    public:
        TestTargetManager(std::vector<NerfusTickerInterface*>& target_timeout_tickers);
        virtual void execute(const std::vector<uint8_t>& target_info_bytes, int *address);
        virtual void target_hit(int target_number);
        virtual void target_missed(int target_number);
        
    private:
        std::vector<NerfusTickerInterface*>& target_timeout_tickers;
};

#endif
