#include "NerfusTicker.hpp"

void NerfusTicker::start(int timeout_ms)
{
    ticker = Ticker();
    ticker.attach_us(callback(this, &NerfusTicker::timeout), timeout_ms * 1000);
    timer.reset();
    timer.start();
}

void NerfusTicker::stop()
{
    ticker.detach();
    timer.stop();
}

int NerfusTicker::get_time_ms()
{
    return timer.read_ms();
}

void NerfusTicker::init(NerfusCallbackInterface *nerfus_callback)
{
    this->nerfus_callback = nerfus_callback;
}

void NerfusTicker::timeout()
{
    nerfus_callback->call();
    stop();
}
