#ifndef BUMPER_HPP
#define BUMPER_HPP

//Limit switch connections:
//  C (common): pin to read
//  NO (normally open): VCC
//  NC (normally closed): GND
//Source: http://www.omron.com.au/service_support/FAQ/FAQ03206/index.asp

#include "mbed.h"
#include "NerfusCallbackInterface.hpp"

class Bumper
{
    public:
        Bumper(PinName pin, NerfusCallbackInterface* nerfus_rise_callback);
        void set_callbacks(NerfusCallbackInterface* nerfus_rise_callback);
        void rise_callback();
        
    private:    
        InterruptIn interrupt_in;
        NerfusCallbackInterface* nerfus_rise_callback;
};

#endif