#include "RealXbeeTransmitter.hpp"
#include <cassert>

RealXbeeTransmitter::RealXbeeTransmitter()
{
    
}

void RealXbeeTransmitter::transmit(const std::vector<uint8_t>& bytes, int address[8])
{
    target_message *message = target_messages_to_transmit.alloc();
    for(int i=0; i<message_size; i++)
    {
        message->bytes[i] = bytes[i];
    }
    for(int i=0; i<8; i++)
    {
        message->address[i] = address[i];
    }
    target_messages_to_transmit.put(message);
}

void RealXbeeTransmitter::transmit(uint8_t bytes[4], int length, int address[8])
{
    target_message *message = target_messages_to_transmit.alloc();
    for(int i=0; i<message_size; i++)
    {
        message->bytes[i] = bytes[i];
    }
    for(int i=0; i<8; i++)
    {
        message->address[i] = address[i];
    }
    target_messages_to_transmit.put(message);
}

void RealXbeeTransmitter::init()
{
    transmit_target_messages_thread.start(callback(this, &RealXbeeTransmitter::transmit_target_message));
}

void RealXbeeTransmitter::transmit_target_message()
{
    while(true)
    {
        osEvent event = target_messages_to_transmit.get();
        assert(event.status == osEventMail);      
        
        target_message *message = (target_message*)event.value.p;
    
        send_message_via_xbee((char*) message->bytes, message_size, message->address);
    }
}
