/////////////////////////////////////////////////////////////
// APP 3                                                   //
//                                                         //
// Université de Sherbrooke                                //
// Génie informatique                                      //
// Session 5, Hiver 2017                                   //
//                                                         //
// Date:    14 février 2017                                //
//                                                         //
// Auteurs: Maxime Dupuis,       dupm2216                  //
//          Bruno Allaire-Lemay, allb2701                  //
/////////////////////////////////////////////////////////////

#include <cassert>
#include <algorithm>
#include "test.h"
#include "xbee.h"

void run_all_tests()
{
    vectors_are_equal_test();
    generate_transmit_request_test();
    generate_led_high_command_test();
    generate_led_low_command_test();
    parse_receive_packet_test();
    parse_frame_parses_receive_packet_test();
    parse_frame_parses_transmit_status_test();
    parse_frame_parses_at_command_response_test();
    parse_frame_parses_remote_command_response_test();
    handle_frame_adds_parsed_frame_to_mailbox_test();
    
    test_create_vector_by_copy_test();
    
    string_to_data_test();
    hexa_char_to_dec_test();
}

void vectors_are_equal_test()
{
    vector<char> v1;    
    v1.push_back(1);
    v1.push_back(2);
    
    vector<char> v2;
    v2.push_back(1);
    v2.push_back(2);
    
    vector<char> v3;
    v3.push_back(1);
    v3.push_back(2);
    v3.push_back(3);
    
    vector<char> v4;
    v4.push_back(1);
    v4.push_back(1);
    
    assert(vectors_are_equal(v1, v2));
    
    assert(!vectors_are_equal(v1, v3));
    assert(!vectors_are_equal(v1, v4));
}

bool vectors_are_equal(const vector<char> v1, const vector<char> v2)
{
    if(v1.size() != v2.size()) return false;
    
    const bool all_elements_are_equal = equal(v1.begin(), v1.end(), v2.begin());
    return all_elements_are_equal;
}

vector<char> construct_vector(const char* content, int length)
{
    vector<char> constructed_vector;
    for(int i = 0; i < length; ++i)
    {
        constructed_vector.push_back(content[i]);
    }
    return constructed_vector;
}

int some_function_that_returns_int_forty_two()
{
    return 42;   
}

void test_create_vector_by_copy_test()
{
    const vector<char> original(2, 3);
    vector<char> *copy_vector = new vector<char>();
    *copy_vector = original;
    
    assert(vectors_are_equal(original, *copy_vector));
    
    delete copy_vector;
    
    assert(original.at(0) == 3);
    assert(original.at(1) == 3);
}

void generate_transmit_request_test()
{
    const char expected_array[] = {0x7E, 0x00, 0x12, 0x10, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x54, 0x65, 0x73, 0x74, 0x53};
    vector<char> expected_request = construct_vector(expected_array, 22);
    
    int address[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF};
    
    vector<char> actual_request = generate_transmit_request("Test", 4, address);
        
    assert(vectors_are_equal(actual_request, expected_request));
}

void generate_led_high_command_test()
{
    const char expected_array[] = {0x7E, 0x00, 0x10, 0x17, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFE, 0x02, 0x50, 0x32, 0x05, 0x63};
    vector<char> expected_request = construct_vector(expected_array, 20);
    
    vector<char> actual_request = generate_led_command(true);
        
    assert(vectors_are_equal(actual_request, expected_request));
}

void generate_led_low_command_test()
{
    const char expected_array[] = {0x7E, 0x00, 0x10, 0x17, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFE, 0x02, 0x50, 0x32, 0x04, 0x64};
    vector<char> expected_request = construct_vector(expected_array, 20);
    
    vector<char> actual_request = generate_led_command(false);
        
    assert(vectors_are_equal(actual_request, expected_request));
}

void parse_receive_packet_test()
{
    const char receive_packet_array[] = {0x7E, 0x00, 0x10, 0x90, 0x00, 0x13, 0xA2, 0x00, 0x40, 0x86, 0xDA, 0x0E, 0x90, 0x1D, 0x01, 0x54, 0x65, 0x73, 0x74, 0xBE};
    vector<char> receive_packet = construct_vector(receive_packet_array, 20);
    
    const char expected_message_array[] = {0x54, 0x65, 0x73, 0x74};
    vector<char> expected_message = construct_vector(expected_message_array, 4);
    
    vector<char> actual_message = parse_receive_packet(receive_packet);
    
    assert(vectors_are_equal(actual_message, expected_message));
}

void parse_frame_parses_receive_packet_test()
{
    const char frame_to_parse_array[] = {0x7E, 0x00, 0x10, 0x90, 0x00, 0x13, 0xA2, 0x00, 0x40, 0x86, 0xDA, 0x0E, 0x90, 0x1D, 0x01, 0x54, 0x65, 0x73, 0x74, 0xBE};
    const vector<char> frame_to_parse = construct_vector(frame_to_parse_array, 20);
    
    const char expected_parsed_frame_array[] = {FRAME_TYPE_RECEIVE_PACKET, 'T', 'e', 's', 't'};
    const vector<char> expected_parsed_frame = construct_vector(expected_parsed_frame_array, 5);
    
    const vector<char> actual_parsed_frame = parse_frame(frame_to_parse);
    
    assert(vectors_are_equal(expected_parsed_frame, actual_parsed_frame));
}

void parse_frame_parses_transmit_status_test()
{    
    const char frame_to_parse_array[] = {0x7E, 0x00, 0x07, 0x8B, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x73};
    const vector<char> frame_to_parse = construct_vector(frame_to_parse_array, 11);
    
    const char expected_parsed_frame_array[] = {FRAME_TYPE_TRANSMIT_STATUS, TRANSMIT_STATUS_SUCCESS};
    const vector<char> expected_parsed_frame = construct_vector(expected_parsed_frame_array, 2);
    
    const vector<char> actual_parsed_frame = parse_frame(frame_to_parse);
    
    assert(vectors_are_equal(expected_parsed_frame, actual_parsed_frame));
}

void parse_frame_parses_at_command_response_test()
{
    const char frame_to_parse_array[] = {0x7E, 0x00, 0x05, 0x88, 0x01, 0x4E, 0x4A, 0x00, 0xDE};
    const vector<char> frame_to_parse = construct_vector(frame_to_parse_array, 9);
    
    const char expected_parsed_frame_array[] = {FRAME_TYPE_AT_COMMAND_RESPONSE, AT_COMMAND_RESPONSE_STATUS_OK};
    const vector<char> expected_parsed_frame = construct_vector(expected_parsed_frame_array, 2);
    
    const vector<char> actual_parsed_frame = parse_frame(frame_to_parse);
    
    assert(vectors_are_equal(expected_parsed_frame, actual_parsed_frame));
}

void parse_frame_parses_remote_command_response_test()
{
    const char frame_to_parse_array[] = {0x7E, 0x00, 0x0F, 0x97, 0x01, 0x00, 0x13, 0xA2, 0x00, 0x40, 0x86, 0xDA, 0x0E, 0x90, 0x1D, 0x50, 0x32, 0x00, 0xD5};
    const vector<char> frame_to_parse = construct_vector(frame_to_parse_array, 19);
    
    const char expected_parsed_frame_array[] = {FRAME_TYPE_REMOTE_COMMAND_RESPONSE, REMOTE_COMMAND_RESPONSE_COMMAND_STATUS_OK};
    const vector<char> expected_parsed_frame = construct_vector(expected_parsed_frame_array, 2);
    
    const vector<char> actual_parsed_frame = parse_frame(frame_to_parse);
    
    assert(vectors_are_equal(expected_parsed_frame, actual_parsed_frame));
}

void handle_frame_adds_parsed_frame_to_mailbox_test()
{
    const char frame_to_handle_array[] = {0x7E, 0x00, 0x05, 0x88, 0x01, 0x4E, 0x4A, 0x00, 0xDE};
    const vector<char> frame_to_handle = construct_vector(frame_to_handle_array, 9);
    
    const char expected_parsed_frame_array[] = {FRAME_TYPE_AT_COMMAND_RESPONSE, AT_COMMAND_RESPONSE_STATUS_OK};
    const vector<char> expected_parsed_frame = construct_vector(expected_parsed_frame_array, 2);
    
    handle_frame(frame_to_handle);
    
    //Read parsed frame from the mailbox
    osEvent event = parsed_frames.get();
    assert(event.status == osEventMail);
    ingoing_value_t *parsed_frame = (ingoing_value_t*)event.value.p;    
    
    assert(vectors_are_equal(expected_parsed_frame, ingoing_value_to_vector(*parsed_frame))); 
   
    parsed_frames.free(parsed_frame);   
}

void string_to_data_test()
{
    vector<char> result;
    
    result = string_to_data("0000");
    assert(result.at(0) == 0);
    assert(result.at(1) == 0);
    
    result = string_to_data("EEEEEE");
    assert(result.at(0) == 0xEE);
    assert(result.at(1) == 0xEE);
}

void hexa_char_to_dec_test()
{    
    assert(hexa_char_to_dec('0') == 0);
    assert(hexa_char_to_dec('1') == 1);
    assert(hexa_char_to_dec('A') == 10);
    assert(hexa_char_to_dec('F') == 15);
    
    assert(hexa_char_to_dec('a') == 10);
    assert(hexa_char_to_dec('f') == 15);
}