/////////////////////////////////////////////////////////////
// APP 3                                                   //
//                                                         //
// Université de Sherbrooke                                //
// Génie informatique                                      //
// Session 5, Hiver 2017                                   //
//                                                         //
// Date:    14 février 2017                                //
//                                                         //
// Auteurs: Maxime Dupuis,       dupm2216                  //
//          Bruno Allaire-Lemay, allb2701                  //
/////////////////////////////////////////////////////////////

#ifndef XBEE_HPP
#define XBEE_HPP

#include <vector>
#include <string>
#include <cassert>
#include "mbed.h"
#include "rtos.h"

struct ingoing_value_t
{
    char content[30];
    int size;
};

//See xbee document page 99
const char FRAME_TYPE_RECEIVE_PACKET = 0x90;
const char FRAME_TYPE_TRANSMIT_STATUS = 0x8B;
const char FRAME_TYPE_AT_COMMAND_RESPONSE = 0x88;
const char FRAME_TYPE_REMOTE_COMMAND_RESPONSE = 0x97;

const char TRANSMIT_STATUS_SUCCESS = 0x00;
const char AT_COMMAND_RESPONSE_STATUS_OK = 0x00;
const char REMOTE_COMMAND_RESPONSE_COMMAND_STATUS_OK = 0x00;

const char EVENT_TYPE_COORDINATOR_TO_ROUTER = 0x00;
const char EVENT_TYPE_ROUTOR_TO_COORDINATOR = 0x01;

const char BUTTON_PRESSED = 0x00;
const char BUTTON_RELEASED = 0x01;

extern Mail<ingoing_value_t, 30> parsed_frames;
extern RawSerial xbee;

extern DigitalOut error_led;
extern Thread error_led_thread;

void manage_error_led();
void send_blink_led_at_command(const bool toggle_current_command);

void send_message_via_xbee(const char* message, const int length, int address[8]);
vector<char> generate_transmit_request(const char* message, const int length, int address[8]);
vector<char> generate_led_command(const bool power_on);
void read_frame();
vector<char> parse_receive_packet(const vector<char>& frame);
vector<char> parse_transmit_status(const vector<char>& frame);
vector<char> parse_at_command_response(const vector<char>& frame);
void handle_parsed_frames_from_mailbox(void const *args);
void handle_frame(const vector<char>& frame);

void parse_nerfus_message(const vector<char>& parsed_frame, void (*callback)(vector<uint8_t>, int*));

//Simplify the frame to only contain the frame type and the relevant data for our application
vector<char> parse_frame(const vector<char>& frame);

vector<char> ingoing_value_to_vector(const ingoing_value_t& value);

vector<string> read_file(string path);
char hexa_char_to_dec(char hexa_char);
vector<char> string_to_data(string pan_id);
void set_pan_id(string pan_id);

#endif