#ifndef REAL_XBEE_TRANSMITTER_HPP
#define REAL_XBEE_TRANSMITTER_HPP

#include "xbee.h"
#include "XbeeTransmitterInterface.hpp"

class RealXbeeTransmitter : public XbeeTransmitterInterface
{  
    public:
        RealXbeeTransmitter();
        virtual void transmit(const std::vector<uint8_t>& bytes, int address[8]);
        virtual void transmit(uint8_t bytes[4], int length, int address[8]);
        void init();
        void transmit_target_message();
    
    private:
        Thread transmit_target_messages_thread;
        const static int message_size = 4;
        
        struct target_message
        {
            uint8_t bytes[message_size];
            int address[8];
        };

        Mail<target_message, 30> target_messages_to_transmit;
};

#endif
