#include "Target.hpp"

int coordinator_address[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

Target::Target(ServomotorInterface& servomotor,
        LedControllerInterface& ally_leds,
        LedControllerInterface& enemy_leds,
        XbeeTransmitterInterface& xbee_transmitter,
        const int target_number):
    servomotor(servomotor),
    ally_leds(ally_leds),
    enemy_leds(enemy_leds),
    xbee_transmitter(xbee_transmitter),
    target_number(target_number)
{
}

void Target::execute_command(Mode mode, int timeout_ms)
{
    if(mode == Ally)
    {
        ally_command();
    }
    else
    {
        enemy_command();
    }
}


void Target::ally_command()
{
    servomotor.set_position_up();
    ally_leds.turn_on();
}

void Target::enemy_command()
{
    servomotor.set_position_up();
    enemy_leds.turn_on();
}

void Target::generate_message(uint8_t target_number, Result result, uint16_t time_taken_ms, uint8_t* message) const
{
    const uint8_t time_taken_msb = time_taken_ms >> 8;
    const uint8_t time_taken_lsb = (time_taken_ms << 8) >> 8;

    message[0] = target_number;
    message[1] = result;
    message[2] = time_taken_msb;
    message[3] = time_taken_lsb;
}

void Target::timeout(const int time_taken_ms)
{    
    servomotor.set_position_down();
    ally_leds.turn_off();
    enemy_leds.turn_off();
    
    uint8_t message[4];
    generate_message(target_number, Target::RESULT_MISSED, time_taken_ms, message);
    xbee_transmitter.transmit(message, 4, coordinator_address);
}

void Target::hit(const int time_taken_ms)
{
    servomotor.set_position_down();
    ally_leds.turn_off();
    enemy_leds.turn_off();
    
    uint8_t message[4];
    generate_message(target_number, Target::RESULT_HIT, time_taken_ms, message);
    xbee_transmitter.transmit(message, 4, coordinator_address);
}
