#include "mbed.h"
#include "RealDigitalOut.hpp"
#include "LedController.hpp"
#include "LedController.hpp"
#include "RealPwmOut.hpp"
#include "RealServomotor.hpp"
#include "RealXbeeTransmitter.hpp"
#include "RealXbeeReceiver.hpp"
#include "Target.hpp"
#include "Calibrator.hpp"
#include "Bumper.hpp"
#include "TargetHitCalibrateCallback.hpp"
#include "TargetHitCallback.hpp"
#include "TargetMissedCallback.hpp"
#include "NerfusTicker.hpp"
#include "TargetManager.hpp"

#include <vector>

TargetManager* target_manager_pointer;

void target_manager_callback(vector<uint8_t> message, int address[8])
{
    target_manager_pointer->execute(message, address);
}

int main() 
{    
    //Transmitter
    RealXbeeTransmitter xbee_transmitter;
    xbee_transmitter.init();
    
    //Target 0
    RealPwmOut servo_pwm_out_0(p21);
    RealServomotor servomotor_0(servo_pwm_out_0);
    servomotor_0.set_position_down();
    
    RealDigitalOut ally_leds_0(p5);
    RealDigitalOut ennemy_leds_0(p6);
    LedController ally_leds_controller_0(ally_leds_0);
    LedController ennemy_leds_controller_0(ennemy_leds_0);
    
    Target target_0(servomotor_0, ally_leds_controller_0, ennemy_leds_controller_0, xbee_transmitter, 0);
    
    //Target 1
    RealPwmOut servo_pwm_out_1(p22);
    RealServomotor servomotor_1(servo_pwm_out_1);
    servomotor_1.set_position_down();
    
    RealDigitalOut ally_leds_1(p9);
    RealDigitalOut ennemy_leds_1(p10);
    LedController ally_leds_controller_1(ally_leds_1);
    LedController ennemy_leds_controller_1(ennemy_leds_1);
    
    Target target_1(servomotor_1, ally_leds_controller_1, ennemy_leds_controller_1, xbee_transmitter, 1);
    
    wait_ms(250);
    
    //Bumpers
    PinName bumper_0_pin = p11;
    PinName bumper_1_pin = p12;
    Bumper bumper_0(bumper_0_pin, NULL);
    Bumper bumper_1(bumper_1_pin, NULL);
    
    //Servomotor calibration
    Calibrator calibrator_0(servomotor_0);
    Calibrator calibrator_1(servomotor_1);
    TargetHitCalibrateCallback target_hit_calibrate_callback_0(calibrator_0);
    TargetHitCalibrateCallback target_hit_calibrate_callback_1(calibrator_1);
    
    bumper_0.set_callbacks(&target_hit_calibrate_callback_0);
    calibrator_0.calibrate();
    servomotor_0.set_position_down();
    printf("Servomotor 0 calibrated\r\n");
    
    bumper_1.set_callbacks(&target_hit_calibrate_callback_1);
    calibrator_1.calibrate();
    servomotor_1.set_position_down();
    printf("Servomotor 1 calibrated\r\n");

    //Target Manager
    vector<TargetInterface*> targets;
    targets.push_back(&target_0);
    targets.push_back(&target_1);
    
    NerfusTicker target_timeout_ticker_0;
    NerfusTicker target_timeout_ticker_1;
    std::vector<NerfusTickerInterface*> target_timeout_tickers;
    target_timeout_tickers.push_back(&target_timeout_ticker_0);
    target_timeout_tickers.push_back(&target_timeout_ticker_1);
    
    TargetManager target_manager(targets, target_timeout_tickers);
    
    //Timeout tickers
    TargetMissedCallback target_missed_callback_0(target_manager, 0);
    TargetMissedCallback target_missed_callback_1(target_manager, 1);
    target_timeout_ticker_0.init(&target_missed_callback_0);
    target_timeout_ticker_1.init(&target_missed_callback_1);
    
    //Bumper 1
    TargetHitCallback target_hit_callback_0(target_manager, 0);
    bumper_0.set_callbacks(&target_hit_callback_0);
    
    //Bumper 2
    TargetHitCallback target_hit_callback_1(target_manager, 1);
    bumper_1.set_callbacks(&target_hit_callback_1);
    
    //Receiver
    target_manager_pointer = &target_manager;
    RealXbeeReceiver xbee_receiver;
    xbee_receiver.start(&target_manager_callback);

    while(1)
    {
    }
}



