cmake_minimum_required(VERSION 3.5)

# Download and unpack target_manager at configure time
configure_file(TargetManager.txt.in
               target_manager-download/CMakeLists.txt)

execute_process(COMMAND ${CMAKE_COMMAND} -G "${CMAKE_GENERATOR}" .
  WORKING_DIRECTORY ${CMAKE_BINARY_DIR}/target_manager-download )
execute_process(COMMAND ${CMAKE_COMMAND} --build .
  WORKING_DIRECTORY ${CMAKE_BINARY_DIR}/target_manager-download )
 
# Add target_manager directly to our build.
add_subdirectory(${CMAKE_BINARY_DIR}/target_manager-src
                 ${CMAKE_BINARY_DIR}/target_manager-build)
 
include_directories("${target_manager_SOURCE_DIR}/include")

