#include "gmock/gmock.h"
#include "gtest/gtest.h"

#include "Servomotor.hpp"
#include "mocks/MockPwmOut.hpp"

TEST(ServomotorTest, SetPositionDown)
{
    MockPwmOut mock_pwm_out;
    Servomotor servomotor(mock_pwm_out);

    EXPECT_CALL(mock_pwm_out, pulsewidth_us(500))
        .Times(1);

    servomotor.set_position_down();
}

TEST(ServomotorTest, SetPositionUp)
{
    MockPwmOut mock_pwm_out;
    Servomotor servomotor(mock_pwm_out);

    EXPECT_CALL(mock_pwm_out, pulsewidth_us(1500))
        .Times(1);

    servomotor.set_position_up();
}

