#include "gmock/gmock.h"
#include "gtest/gtest.h"

#include "LedController.hpp"
#include "mocks/MockDigitalOut.hpp"

TEST(LedController, TurnOn)
{
    MockDigitalOut mock_digital_out;
    LedController led_controller(mock_digital_out);

    EXPECT_CALL(mock_digital_out, write(1))
        .Times(1);

    led_controller.turn_on();
}

TEST(LedController, TurnOff)
{
    MockDigitalOut mock_digital_out;
    LedController led_controller(mock_digital_out);

    EXPECT_CALL(mock_digital_out, write(0))
        .Times(1);

    led_controller.turn_off();
}
