#include "Calibrator.hpp"
#include "mbed.h"

Calibrator::Calibrator(Servomotor& servomotor):
    servomotor(servomotor),
    is_bumper_pressed(false)
{
}

void Calibrator::calibrate()
{
    float angle;
 
    for(angle = 50; !is_bumper_pressed && angle <= 125; angle++)
    {
        servomotor.set_angle(angle);
        angle++;
        wait_ms(25);
    }
    angle -= 3;

    servomotor.up_angle = angle;
}

void Calibrator::on_rise()
{
    is_bumper_pressed = true;
}
        