#ifndef TARGET_MANAGER_HPP
#define TARGET_MANAGER_HPP

#include "NerfusTickerInterface.hpp"
#include "TargetInfo.hpp"
#include "TargetInterface.hpp"
#include "TargetManagerInterface.hpp"

#include <vector>
#include "stdint.h"

class TargetManager : public TargetManagerInterface
{
    public:
        TargetManager(std::vector<TargetInterface*>& targets, std::vector<NerfusTickerInterface*>& nerfus_tickers);

        void execute(const TargetInfo& target_info);
        virtual void execute(const std::vector<uint8_t>& target_info_bytes, int *address = 0);

        virtual void target_missed(int target_id);
        virtual void target_hit(int target_id);

    private:
        std::vector<TargetInterface*>& targets;
        std::vector<NerfusTickerInterface*>& nerfus_tickers;
        std::vector<bool> is_active_target;
};

#endif
