#ifndef TARGET_HPP
#define TARGET_HPP

#include "ServomotorInterface.hpp"
#include "LedControllerInterface.hpp"
#include "XbeeTransmitterInterface.hpp"
#include "TargetInterface.hpp"

#include "stdint.h"

extern int coordinator_address[];

class Target : public TargetInterface
{
    public:
        enum Result
        {
            RESULT_HIT,
            RESULT_MISSED
        };

        enum Mode
        {
            Ally,
            Enemy
        };

        Target(ServomotorInterface &servomotor,
            LedControllerInterface &ally_leds,
            LedControllerInterface &enemy_leds,
            XbeeTransmitterInterface &xbee_transmitter,
            int target_number);
        void execute_command(Mode mode, int timeout_ms);
        virtual void ally_command();
        virtual void enemy_command();
        void generate_message(uint8_t target_number, Result result, uint16_t time_taken_ms, uint8_t* message) const;
        virtual void timeout(int time_taken_ms);
        virtual void hit(int time_taken_ms);

    private:
        ServomotorInterface &servomotor;
        LedControllerInterface &ally_leds;
        LedControllerInterface &enemy_leds;
        XbeeTransmitterInterface &xbee_transmitter;
        const int target_number;
};

#endif
