#include "PrecisionMode.hpp"

TargetInfo * PrecisionMode::GetNextTarget()
{
    if (numberOfRounds-- == 0) {
        return NULL;
    }
    TargetInfo * new_target = &((*this->targets)[currentTarget]);

    currentTarget = (currentTarget + 1) % this->targets->size();
    new_target->type = TARGET_TYPE_ENEMY;
    new_target->timeout_ms = 30000; //30 seconds

    return new_target;
}

void PrecisionMode::OnTargetHit(int timeTaken)
{
    stats.numberOfHits++;
    points += 2;
}
void PrecisionMode::OnTargetMiss()
{
    stats.numberOfMiss++;
    points -= 5;
}

GameStats PrecisionMode::GetStats()
{
    //Seems pretty basic... move to PlayableGame class ?
    
    //TODO: Complete the stats
    //stats.timeTaken
    //stats.averageTimePerTarget
    return stats;
}