#include "gmock/gmock.h"
#include "gtest/gtest.h"

#include "GameCoordinator.hpp"
#include "MockRandomNumberGenerator.hpp"

TEST(GameCoordinatorTest, GenerateRandomTargetCourse)
{
    MockRandomNumberGenerator mock_random_number_generator;
    EXPECT_CALL(mock_random_number_generator, get(0, 4))
        .Times(5)
        .WillOnce(::testing::Return(1))
        .WillOnce(::testing::Return(5))
        .WillOnce(::testing::Return(2))
        .WillOnce(::testing::Return(3))
        .WillOnce(::testing::Return(1));
    EXPECT_CALL(mock_random_number_generator, get(0, 1))
        .Times(5)
        .WillOnce(::testing::Return(0))
        .WillOnce(::testing::Return(1))
        .WillOnce(::testing::Return(1))
        .WillOnce(::testing::Return(0))
        .WillOnce(::testing::Return(1));

    std::vector<TargetInfo> expected_targets;
    expected_targets.push_back(make_TargetInfo(1, TARGET_TYPE_ALLY, 42));
    expected_targets.push_back(make_TargetInfo(5, TARGET_TYPE_ENEMY, 42));
    expected_targets.push_back(make_TargetInfo(2, TARGET_TYPE_ENEMY, 42));
    expected_targets.push_back(make_TargetInfo(3, TARGET_TYPE_ALLY, 42));
    expected_targets.push_back(make_TargetInfo(1, TARGET_TYPE_ENEMY, 42));

    GameCoordinator game_coordinator(mock_random_number_generator);
    const std::vector<TargetInfo> actual_targets = game_coordinator.generate_random_target_course(5, 42);

    EXPECT_THAT(expected_targets, ::testing::ContainerEq(actual_targets));
}

