#include "PlayableGame.hpp"

PlayableGame::PlayableGame(std::vector<TargetInfo> *targets, RandomNumberGenerator& random_number_generator) :
    random_number_generator(random_number_generator)
{
}

bool PlayableGame::IsWeaponValid(int weaponId)
{
    return true;
}

TargetInfo *PlayableGame::GetRandomTarget(int timeout_ms)
{
    TargetInfo* new_target;
    new_target = &(this->targets->at(random_number_generator.get(0,  this->targets->size())));
    
    new_target->type = random_number_generator.get(0, 1) == 0 ? TARGET_TYPE_ALLY : TARGET_TYPE_ENEMY;
    new_target->timeout_ms = timeout_ms;

    return new_target;
}

int PlayableGame::GetPoints()
{
    return points;
}

void PlayableGame::Start()
{
    iteration_timer.start(getTargetSpeed);
}

void PlayableGame::Stop()
{
    iteration_timer.stop();
}

void PlayableGame::TimerDoIteration()
{
    TargetInfo * nextTarget = GetNextTarget();
    nextTarget->riseTarget();
}

GameStats PlayableGame::GetStats()
{
    stats.accuracy = stats.numberOfHits * 10000 / (stats.numberOfHits + stats.numberOfMiss);
    return stats;
}