#include "GameCoordinator.hpp"

GameCoordinator::GameCoordinator(RandomNumberGenerator &random_number_generator) : random_number_generator(random_number_generator)
{
    PrecisionMode precisionMode(&(this->targets), random_number_generator);
    this->gameModes[0] = &precisionMode;
}

std::vector<TargetInfo> GameCoordinator::generate_random_target_course(const int number_of_targets, const int timeout_ms)
{
    std::vector<TargetInfo> target_course;

    for (int i = 0; i < number_of_targets; ++i)
    {
        TargetInfo new_target;

        new_target.id = random_number_generator.get(0, number_of_targets - 1);
        new_target.type = random_number_generator.get(0, 1) == 0 ? TARGET_TYPE_ALLY : TARGET_TYPE_ENEMY;
        new_target.timeout_ms = timeout_ms;

        target_course.push_back(new_target);
    }

    return target_course;
}
