#pragma once

#include <vector>
#include "Target.hpp"
#include "RandomNumberGenerator.hpp"
#include "rtos.h"

struct GameStats
{
  int timeTaken; //ms
  int numberOfHits;
  int numberOfMiss;
  int accuracy;             //4 digits percentage to avoid a float
  int averageTimePerTarget; //ms
};

//Abstract class, must be implemented as a GameMode
class PlayableGame
{
public:
  PlayableGame(std::vector<TargetInfo> *targets, RandomNumberGenerator& random_number_generator);
  ~PlayableGame();

  virtual bool IsWeaponValid(int weaponId); //Default to any Weapons
  virtual int GetPoints();
  virtual GameStats GetStats();
  virtual TargetInfo* GetNextTarget() = 0;

  void Start(); //Create a thread that will call GetNextTarget at set speed
  void Stop(); //Stop the thread
  int getTargetSpeed = 10; //ms

protected:
  int points;
  GameStats stats;
  TargetInfo *GetRandomTarget(int timeout_ms);
  std::vector<TargetInfo>* targets;

  virtual void OnTargetHit(int timeTaken) = 0;
  virtual void OnTargetMiss() = 0;

private:
  RandomNumberGenerator& random_number_generator;
  RtosTimer iteration_timer(TimerDoIteration);
  void TimerDoIteration();
};