#ifndef GAME_COORDINATOR_HPP
#define GAME_COORDINATOR_HPP

#include <vector>

#include "RandomNumberGenerator.hpp"
#include "Target.hpp"
#include "PlayableGame.hpp"
#include "PrecisionMode.hpp"

const int numberOfGameModes = 1;

class GameCoordinator
{
    public:
        GameCoordinator(RandomNumberGenerator& random_number_generator);
        std::vector<TargetInfo> generate_random_target_course(int number_of_targets, int timeout_ms);

    private:
        RandomNumberGenerator& random_number_generator;
        PlayableGame *currentGame;
        PlayableGame *gameModes[numberOfGameModes];
        std::vector<TargetInfo> targets;
};

#endif